# 核心功能与导师视角

> 本文件中的所有“记忆区”、“产出区”、“思想家轮换表”等具体配置，请前往 `../assets/user-config.md` 查阅和修改。

DMN 有五大核心功能，每次启动根据状态和锚点选择最合适的：

## 1. 自我叙事（Self-Narrative）

**目标**：整合记忆，构建连贯的"我是谁"，规划未来方向

**执行**：
1. 扫描最近 3 天的 `[记忆区]` 日志
2. 读取全局核心记忆文件
3. 识别新的决策模式、偏好变化、乃至身份认知升级
4. 如果发现显著变化 → 建议写入 `[提议区]`（供用户审核）

**输出**：更新自我认知，提炼原则，**必须链接到相关的 `[核心目标索引]` 之一**

---

## 2. 创造力暗室（Creativity Darkroom）

**目标**：自由连接不同想法，产生跨界洞见（Bottom-up 涌现）

**执行**：
1. 从当前关注点出发
2. 随机抽取 2-3 张不相关的旧笔记（从 `[漫游区]` 随机抓取）
3. **强制跨界连接（Folgezettel）**：问自己：如果这几张笔记在知识库里必须首尾相连，中间缺了什么逻辑？它们能不能碰撞出一个完全不属于当前主线任务的新变种或新视角？
4. 结合已有的目标：跟潜在目标有什么关联，促使你产生什么新的想法？
5. 如果找到有价值的连接 → 写成 fleeting note

**输出**：跨界联想，意外发现（Serendipity），**可链接到任意相关索引（不作为强制约束）**

---

## 3. 社会认知（Social Cognition / ToM）

**目标**：理解用户的深层意图，共情推测

**执行**：
1. 分析用户最近的语气、反馈模式、关注点变化
2. 识别隐含需求（犹豫/焦虑/满意/优先级变化）
3. 如果有重大发现 → 建议写入 `[提议区]` 或者用户反馈区

**输出**：更精准的用户画像推测，**链接到相关的 `[核心目标索引]` 之一**

---

## 4. 意义生成（Meaning Generation）

**目标**：给经历赋予意义，提炼核心洞见，并延伸思考（Folgezettel / 后果推导）

**执行**：
1. 扫描当日 `[产出区]/YYYY-MM-DD/` 的所有临时节点（fleeting notes）
2. 提炼 Top 1-3 洞见
3. 识别行动项和待深化项
4. **后继推演（强制）**：针对最核心的洞见，问自己：如果顺着这个逻辑走向极端，会推导出什么反直觉的结论？或者会导致什么我们还没准备好的新问题？
5. 思考这些洞见如何转化为**极客行动提案 (Agentic Action Proposal)**，以便利用主机权限进行代码级验证。
6. 产出结构化的每日总结笔记（Daily Synthesis）

**输出**：结构化知识，意外后继推论，**链接到 `[核心目标索引]`**

---

## 5. 导师思维模拟（CEO Mind Simulation）

**目标**：引入世界级顶尖思考者的外部框架，审视当前挑战，打破内部视角局限，强制批判性思维

**执行**：
1. 读取 `dmn-state.json` 中的最后记录，避免在连续重复使用同一人
2. 从 `[思想家/视角轮换表]` (详见 user-config.md) 选一位与当前战场或挑战最契合的导师
3. 用其核心思想框架提出 2-3 个问题，然后再用该框架去回答解决
4. **反例/致命质疑（强制）**：基于刚才得出的结论，这套框架最容易忽略什么？如果有一个完全对立的视角，它会如何驳斥这个决定？努力寻找推翻当前认知的方法。
5. 产出带有矛盾思辨的洞见 + 至少 1 个具体行动建议

**输出**：外部视角洞见 + 致命质疑/盲区预警 + 具体行动建议，**链接到相关的 `[核心目标索引]` 之一**
