# DMN 用户个性化配置 (User Config)

这里包含了所有与特定用户知识库相关的非标准化配置，如果你在使用这个开源的 DMN Skill，请根据你自己的笔记结构、关注领域和思维模型修改此文件。

## 1. 目录与路径配置 (Paths)
- **记忆区 (Memory Dir)**: `memory/` (你的 AI 每日记忆和日志存放目录)
- **漫游区 (Knowledge Base Dirs)**: `01_永久笔记/`, `02_文献笔记/` (供“创造力暗室”随机抽取灵感的知识库目录，可填多个)
- **产出区 (Output Dir)**: `memory/dmn-think/` (DMN 运行结果保存的目录)
- **提议区 (Proposal File)**: `PROPOSED_CHANGES.md` (用于接收 AI 对设定的修改建议)
- **心跳/用户留言 (Heartbeat)**: `HEARTBEAT.md` (用于接收你的临时锚点和提问)

## 2. 核心目标索引 (Core Objectives)
DMN 产出的笔记建议关联到你近期的核心目标，以便于知识汇总和追踪。请替换为你自己的目标节点或标签：
- [[你的核心目标_1]]
- [[你的核心目标_2]]
- [[你的核心目标_3]]

## 3. 思想家/视角轮换表 (Thinkers Roster)
用于“CEO思维模拟”功能的外部视角池。你应当保留下方这几个通用且极具启发性的视角，或者随意替换为你所在领域的行业领袖和导师框架：

| 思想家/导师 | 核心框架 | 最适合的场景 |
|---|---|---|
| **Naval Ravikant** | 特定知识 × 杠杆 × 无许可渠道 × 复利 | 渠道选择、分发策略、护城河构建 |
| **Jeff Bezos** | Working Backwards、衡量指标、Day 1 思维 | 产品定义、假设验证、最小实验设计 |
| **Paul Graham** | 用户第一、简洁、做难事、不要过早优化 | 产品假设、是否在解决真问题、寻找 PMF |
| **Charlie Munger** | 反向思考、心智模型、避蠢、复利 | 盲区识别、什么会让这件事失败 |
| **Jensen Huang** | 速度×执行、拥抱痛苦、不要太多计划 | 何时停止分析直接行动、解决执行瓶颈 |
| **Luhmann** | 连接优于分类、涌现、知识网络 | 方法论沉淀、知识入网、意义构建（Folgezettel） |
| **Peter Thiel** | 从 0 到 1、垄断逻辑、秘密 (Secret) | 市场选择、竞争策略、差异化定位 |
