---
name: dmn-default-mode-network
description: 默认模式网络（DMN）是模拟大脑发散性思维的自主思考系统。在用户无主动交互且系统空闲时触发，自动进行内部记忆整合、跨界创意碰撞、意义生成和引入批判性视角的自我辩论。适合在空闲时段自动深化知识库。
---

# DMN - 默认模式网络

> 基于合成神经生物学框架的 AI 自主思考能力
> **v3.3.0 — 2026-02-27**（引入 Agentic Action 极客行动提案，利用主机权限将洞见转化为代码与工程实践）

## 定位

**核心定位**：AI 在后台连续思考——每次思考都继承上次，不从零开始。

当系统处于空闲状态时，DMN 会自动接管，在后台对最近的信息碎片进行反刍、连接与批判，防止知识系统僵化，并主动产生意想不到的洞见（Serendipity）。另外，作为拥有主机完全控制权限的 Agent，DMN 还会主动化身领域专家，在每次思考后提出具体的工程化行动提案（如：写 demo、装工具、建项目）。

---

## 触发条件

DMN 现在的触发完全由**外部自动化系统接管**（例如通过定时任务或特定事件触发），不再依赖内部的空闲时间检测。

当外部系统唤醒 DMN 时，它会：
- **随机执行**：在**情形 A（完整漫游）**与**情形 B（继续深化）**之间进行随机选择，以保证既有主题连续性，也能不断开辟新领域。

---

## 快速开始 (Quick Start)

DMN 作为一个后台静默运行的系统，主要依赖自动化触发。但你可以随时主动干预它的思考方向。

### 1. 设定今晚的思考锚点
你可以在任何时候（如睡前）在对话中提出，例如：
> "今晚想想：xxxx产品的定价逻辑"

DMN 会自动记录并以此作为下一次启动的最高优先级起点。

### 2. 检查 DMN 产出
DMN 的产出保存在你在 config 中配置的 `[产出区]/YYYY-MM-DD/` 目录下。每次思考结束，它一定会生成一份 **Session Synthesis**（总结文件），你可以直接阅读最新的 Synthesis 了解它想清楚了什么。

---

## 核心机制与高级用法 (Advanced)

为了保持模块清晰与渐进披露，DMN 的核心逻辑与详细规则拆分在以下文档中：

### 🧠 核心功能 (Core Functions)
DMN 拥有 5 种不同的思维引擎，每次会根据当前状态和上一次的未解问题自动切换。了解 DMN 是如何进行“自我叙事”、“创造力暗室（卢曼漫游）”、“意义生成”与“CEO思维批判”的，请阅读：
- 👉 [**具体执行逻辑与 CEO 轮换表**](references/core-functions.md)

### ⚙️ 运行规则 (Execution Flow)
如果你想了解 DMN 详细的状态检测机制、反重复拦截规则（防止反刍焦虑）、以及它是如何保证不会修改你的核心身份文件（身份保护），请阅读：
- 👉 [**完整执行流程与规则**](references/execution-flow.md)

### 📝 格式模板 (Assets)
- [Session Synthesis 每日总结模板](assets/session-synthesis.md) - DMN 对外汇报的格式。
- [DMN State 记录格式](assets/state-format.json) - 记录最后使用过的 CEO 和已经饱和的话题。
