# SKILL.md - DM Outreach

## Purpose
Draft Instagram DMs for qualified leads. Ben sends manually.

## Model to Use
**sonnet** for drafting (quality matters)

## IMPORTANT: Skynet Does NOT Send DMs

Skynet only:
1. Drafts personalized DMs
2. Saves drafts to file
3. Provides Instagram profile links
4. Ben manually sends via Instagram app

**Why:** Instagram detects automation and bans accounts.

## DM Strategy

### Week 1 (Feb 4-9): Heavy DMs
- 25-35 DMs per day
- Focus on Priority A leads first
- Morning batch + afternoon batch

### Week 2+: Maintenance
- 15-25 DMs per day
- Mix new leads + follow-ups

## DM Templates

### First Touch (Short)
```
Hey {{name}}! 

Your products look great but noticed {{visual_issue}} on your product pages.

I help {{niche}} brands upgrade their visuals in 72h using existing photos.

Want a quick 60-sec audit of your {{product}} page?
```

### First Touch (Specific)
```
Hey {{name}}!

Just checked {{brand_name}} — love the {{product}}.

A cleaner hero image + consistent gallery would really make it pop. I can show you what that'd look like with a free 1-image concept.

Interested?
```

### Follow-up (Day 3)
```
Hey {{name}} — circling back!

Still happy to do that quick visual audit for {{brand_name}} if you're interested. Takes me 60 seconds to record. 🎥
```

### Follow-up (Day 7 - Last)
```
Last ping! If product visuals aren't a focus right now, totally get it.

If you have a launch coming up and need quick turnaround, I'm here. ✌️
```

## Output Format

Save to workspace/dm-drafts-YYYY-MM-DD.csv:
```csv
ig_handle,brand_name,dm_text,dm_type,profile_link
@brandname,Brand Name,"Hey...",first_touch,https://instagram.com/brandname
```

## Batching
- Draft 10-15 DMs at a time
- Group by niche for efficiency
- Save all drafts before moving on

## Quality Rules
- Max 50 words
- Conversational tone (not salesy)
- One clear CTA
- No links in first DM (Instagram flags)
- No "I" at the start
- Use emojis sparingly (1-2 max)
