---
name: dizest-summarize
description: "Summarize long-form content — articles, podcasts, research papers, PDFs, notes, and more — using the Dizest API. Turn what you read into structured, searchable knowledge."
metadata: {"openclaw":{"emoji":"📝","requires":{"env":["DIZEST_API_KEY"]}}}
---

# Dizest Summarize

Summarize long-form content and turn it into structured, searchable knowledge. Powered by the API behind [Dizest: AI Summarizer](https://www.dizest.ai) — available on the [App Store](https://apps.apple.com/app/id6752311120) and [Google Play](https://play.google.com/store/apps/details?id=com.ideas116.dizest).

**Base URL:** `https://api.116ideas.com`

Visit [www.dizest.ai](https://www.dizest.ai) for more information about the product.

---

## When to Use This Skill

Use this skill when the user asks to:

- Summarize research papers or academic content to extract key findings
- Summarize long podcasts, interviews, or video content from YouTube and other platforms
- Process articles, blog posts, or web content (by URL)
- Summarize PDFs, reports, market analysis, or business documents
- Summarize plain text such as notes, transcripts, or pasted content
- Summarize any of the above with a custom focus (e.g., "focus on methodology and key findings")

---

## Critical Agent Behavior

**The agent MUST act as a thin client.** Specifically:

- **Do NOT** extract, parse, or classify URLs from the user's input.
- **Do NOT** attempt to determine whether the input is a URL, plain text, or text with an embedded URL.
- **Do NOT** fetch, scrape, or pre-process any content before calling the API.
- **Do NOT** handle paywalled content or attempt workarounds.

All content analysis, URL detection, extraction, paywall handling, and execution logic is performed **server-side**. The agent's only job is to forward the user's input to the API exactly as provided.

---

## Authentication

All requests require the `x-api-key` header. The value should come from the `DIZEST_API_KEY` environment variable. Only paid users have valid API keys.

```
x-api-key: $DIZEST_API_KEY
```

If the `DIZEST_API_KEY` environment variable is not set and the user has not provided an API key, prompt them to create one at [dizest.ai/api/keys](http://dizest.ai/api/keys) (requires a paid Dizest account).

---

## API Flow

There are two steps: **create an execution**, then **retrieve the results**.

### Step 1: Create Execution

**Endpoint:**

```
POST https://api.116ideas.com/v1/summarize
```

**Headers:**

```
Content-Type: application/json
x-api-key: $DIZEST_API_KEY
```

**Request Body (minimal):**

```json
{
  "content": "<user input>"
}
```

**Request Body (with custom instructions):**

```json
{
  "content": "<user input>",
  "custom_instructions": "<what to focus on>"
}
```

**Request Body (with output language):**

```json
{
  "content": "<user input>",
  "output_language": "ja"
}
```

Pass the user's input directly as the `content` value. Do not modify, parse, or pre-process it.

**Request Fields:**

| Field                | Type   | Required | Description                                                                 |
|----------------------|--------|----------|-----------------------------------------------------------------------------|
| `content`            | string | Yes      | The user's input to summarize. Pass as-is without modification.             |
| `custom_instructions`| string | No       | Focus instructions for the summary (e.g., "focus on key findings").         |
| `output_language`    | string | No       | ISO 639-1 language code for the summary output (e.g., `"ja"`, `"es"`). Defaults to `"en"`. |

**Response:**

```json
{
  "execution_id": "b7e2c1a4-93f1-4d2a-8e56-1a2b3c4d5e6f",
  "cached": false
}
```

| Field          | Type    | Description                                                  |
|----------------|---------|--------------------------------------------------------------|
| `execution_id` | string  | UUID identifying this execution. Used to retrieve results.   |
| `cached`       | boolean | `true` if result was cached and is ready immediately.        |

### Step 2: Retrieve Results

Use the `execution_id` from Step 1 to retrieve the summary. There are two methods.

#### Preferred: Server-Sent Events (SSE) Stream

```
GET https://api.116ideas.com/v1/executions/<execution_id>/events
```

**Headers:**

```
x-api-key: $DIZEST_API_KEY
```

The server responds with a stream of Server-Sent Events. Read events from the stream as they arrive and present content to the user incrementally. The stream closes when the execution is complete.

#### Fallback: JSON Polling

> **Note:** The polling endpoint is not yet available. SSE is the only supported retrieval method in v1. This section will be updated when polling support is added.

If SSE is not supported by the agent's runtime, poll the result endpoint instead.

```
GET https://api.116ideas.com/v1/executions/<execution_id>/result
```

**Headers:**

```
x-api-key: $DIZEST_API_KEY
```

Poll this endpoint at reasonable intervals (e.g., every 2–3 seconds) until the result is available. The response is a JSON object containing the final summary.

---

## Examples

### Example 1: Summarize a URL

User says: *"Summarize https://example.com/article-about-ai"*

**POST /v1/summarize**

```json
{
  "content": "https://example.com/article-about-ai"
}
```

### Example 2: Summarize Text with an Embedded URL

User says: *"Can you summarize this for me? I found it interesting: https://example.com/post/12345"*

**POST /v1/summarize**

```json
{
  "content": "Can you summarize this for me? I found it interesting: https://example.com/post/12345"
}
```

> Forward the entire input as-is. Do not extract the URL.

### Example 3: Summarize Plain Text

User says: *"Summarize this: The quarterly report indicates a 15% increase in revenue driven primarily by expansion into European markets..."*

**POST /v1/summarize**

```json
{
  "content": "The quarterly report indicates a 15% increase in revenue driven primarily by expansion into European markets..."
}
```

### Example 4: Summarize a Podcast or Video

User says: *"Summarize this podcast https://www.youtube.com/watch?v=dQw4w9WgXcQ"*

**POST /v1/summarize**

```json
{
  "content": "https://www.youtube.com/watch?v=dQw4w9WgXcQ"
}
```

### Example 5: Custom Instructions

> **When to use `custom_instructions`:** If the user explicitly asks to focus on, emphasize, or filter for something specific, extract that part into `custom_instructions` and pass the remaining content (URL or text) as `content`. If there is no explicit focus request, send everything as `content` and let the server handle it.

User says: *"Summarize https://example.com/research-paper but focus on the methodology and key findings"*

**POST /v1/summarize**

```json
{
  "content": "https://example.com/research-paper",
  "custom_instructions": "Focus on the methodology and key findings"
}
```

---

## Output Expectations

- The API returns a summary generated server-side.
- Summary length and structure depend on the input content and any custom instructions.
- Present the summary to the user as-is. Do not further condense or reformat unless the user requests it.

---

## Troubleshooting

| Problem | Cause | Resolution |
|---|---|---|
| `401 Unauthorized` | Missing or invalid `x-api-key` header. | Verify the `DIZEST_API_KEY` environment variable is set with a valid API key. Only paid users have valid keys. |
| `403 Forbidden` | The API key does not have access. | Confirm the key belongs to a paid account. |
| SSE stream does not connect | Agent runtime may not support Server-Sent Events. | Fall back to polling `GET /v1/executions/<execution_id>/result`. |
| Polling returns no result | The execution is still processing. | Continue polling every 2–3 seconds. Allow sufficient time for longer content. |
| Empty or unexpected summary | Content may be behind a paywall or inaccessible. | Inform the user. Do not attempt client-side workarounds — the server handles extraction. |
