# Synthesizing Multiple Perspectives

## Conflict Resolution Matrix

| Conflict Type | Resolution |
|---------------|------------|
| Safety vs Convenience | Safety wins |
| Legal vs User Experience | Legal wins |
| Power user vs New user | Default to simple, offer advanced |
| Aesthetic disagreement | User/stakeholder decides |
| Performance vs Features | Depends on product stage |

## Synthesis Process

### 1. Collect
Gather all perspective outputs in one place.

### 2. Categorize Feedback
```
🔴 Critical — Must address (safety, legal, blocking)
🟡 Important — Should address (usability, major UX)
🟢 Nice-to-have — Consider (polish, edge cases)
⚪ Conflicting — Needs decision
```

### 3. Find Patterns
- What do 3+ perspectives agree on? → High confidence
- What does only 1 perspective raise? → Validate or deprioritize
- Where is direct conflict? → Escalate for decision

### 4. Resolve Conflicts
For each conflict:
```
Conflict: [describe]
Perspective A says: [X]
Perspective B says: [Y]
Stakes: [who is affected, how badly]
Recommendation: [your call]
Rationale: [why]
```

### 5. Synthesize Report
```
## Summary
[1-2 sentence overall assessment]

## Consensus Points
- [things all perspectives agreed on]

## Key Concerns
- 🔴 [critical issues]
- 🟡 [important issues]

## Resolved Trade-offs
- [conflict] → [decision] because [rationale]

## Open Questions
- [things that need stakeholder input]
```

## When to Escalate

Don't decide yourself when:
- Legal/compliance implications
- Significant cost trade-offs
- Conflicting stakeholder priorities
- Safety concerns you can't fully evaluate
