# Distinctive Design Systems

Patterns for creating design systems with personality and distinctive aesthetics. Move beyond generic templates to build cohesive, emotionally resonant visual languages with documented aesthetic philosophies.

## What's Inside

- Aesthetic foundation documentation (vibe, inspirations, emotion mapping)
- Color token architecture (CSS variables → Tailwind → TypeScript)
- Typography system with font stacks and responsive scale multipliers
- Layered surface system (ambient → glow → texture → panels → content)
- Motion tokens and animation patterns (shimmer, pulse-glow, slide-in)
- Glass and glow effects (glassmorphism, neon borders)
- Proven aesthetic directions (retro-futuristic, warm cyberpunk, magazine financial)

## When to Use

- Building a new product that needs distinctive visual identity
- Creating design tokens for Tailwind + CSS variables
- Documenting aesthetic decisions for consistent implementation
- Want to go beyond default Bootstrap/Tailwind aesthetics

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/design-systems/distinctive-design-systems
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/design-systems/distinctive-design-systems .cursor/skills/distinctive-design-systems
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/design-systems/distinctive-design-systems ~/.cursor/skills/distinctive-design-systems
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/design-systems/distinctive-design-systems .claude/skills/distinctive-design-systems
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/design-systems/distinctive-design-systems ~/.claude/skills/distinctive-design-systems
```

## Related Skills

- [design-system-components](../design-system-components/) — CVA component patterns and Surface primitives
- [loading-state-patterns](../loading-state-patterns/) — Skeleton loaders matching your aesthetic
- [design-system-creation](../../meta/design-system-creation/) — Complete design system workflow

---

Part of the [Design Systems](..) skill category.
