---
name: deepgram-discord-voice
description: Voice-channel conversations in Discord using Deepgram streaming STT + low-latency TTS
metadata:
  clawdbot:
    config:
      requiredEnv:
        - DISCORD_TOKEN
        - DEEPGRAM_API_KEY
      optionalEnv: []
      example: |
        {
          "plugins": {
            "entries": {
              "deepgram-discord-voice": {
                "enabled": true,
                "config": {
                  "streamingSTT": true,
                  "streamingTTS": true,
                  "ttsVoice": "aura-2-thalia-en",
                  "vadSensitivity": "medium",
                  "bargeIn": true,

                  "primaryUser": "atechy",
                  "allowVoiceSwitch": true,
                  "wakeWord": "openclaw",

                  "deepgram": {
                    "sttModel": "nova-2",
                    "language": "en-US"
                  }
                }
              }
            }
          }
        }
---

# Deepgram Discord Voice (Clawdbot/OpenClaw Plugin)

This plugin lets you talk to your agent **only from a Discord voice channel**.

Pipeline (low latency):
- Discord voice audio → **Deepgram streaming STT** (WebSocket)
- Transcript → your agent
- Agent reply → **Deepgram TTS** (`/v1/speak` streamed HTTP Ogg/Opus)
- Audio played back into the voice channel

## Requirements

- A Discord bot token (`DISCORD_TOKEN`)
- A Deepgram API key (`DEEPGRAM_API_KEY`)
- Discord bot permissions in your server:
  - **Connect**
  - **Speak**
  - **Use Voice Activity**

## Install

### Option A: Install from ClawHub

1. In your OpenClaw/Clawdbot dashboard, open **Skills/Plugins**.
2. Add/install **deepgram-discord-voice**.
3. Set the required environment variables.

### Option B: Manual install

1. Copy this folder into your extensions/plugins directory.
2. Run:

```bash
npm install
```

3. Restart OpenClaw/Clawdbot.

## Configuration

### Key settings

- `primaryUser` (recommended): Who the bot listens to by default.
  - Best: your **Discord user ID** (numeric)
  - Also supported: username/display name (e.g., `atechy`) if unique in-channel

- `allowVoiceSwitch`: If `true`, the primary user can switch who is allowed by voice.

- `wakeWord`: Prefix for voice control commands. Default: `openclaw`.

- `deepgram.sttModel`: Default `nova-2`.
- `deepgram.language`: Optional BCP‑47 language tag (e.g., `en-US`, `es`, `es-EC`).
- `ttsVoice`: Deepgram Aura voice model (e.g., `aura-2-thalia-en`).

### Example config

```json5
{
  "plugins": {
    "entries": {
      "deepgram-discord-voice": {
        "enabled": true,
        "config": {
          "streamingSTT": true,
          "streamingTTS": true,

          "primaryUser": "atechy",
          "allowVoiceSwitch": true,
          "wakeWord": "openclaw",

          "ttsVoice": "aura-2-thalia-en",
          "vadSensitivity": "medium",
          "bargeIn": true,

          "deepgram": {
            "sttModel": "nova-2",
            "language": "en-US"
          }
        }
      }
    }
  }
}
```

## Usage

### Join a voice channel

Use the plugin tool or slash command (depends on your OpenClaw setup):
- Join: `action=join` with the `channelId`
- Leave: `action=leave`

### Talk (voice channel)

Once the bot is connected, just speak.

### Safeguard: only listen to you (default)

When `primaryUser` is set, the plugin will only listen to that user unless you allow someone else.

### Let someone else talk (voice commands)

As the primary user, say:
- `openclaw allow <name>`
- `openclaw listen to <name>`

To lock it back:
- `openclaw only me`
- `openclaw reset`

### Switch via tool actions (optional)

- `allow_speaker` with `user` (id / @mention / name)
- `only_me`
- `status`

## Notes

- Lowest latency comes from `streamingSTT=true` and `streamingTTS=true`.
- Deepgram TTS is streamed over HTTP in **Ogg/Opus** so Discord can play it immediately.
