# Discord Formatting Templates

Copy-paste templates for common Discord formatting patterns. Replace placeholder content with your own.

## Announcements

> **Note:** Announcement templates include `@everyone` to notify the whole server. Remove it if you only want to post without pinging, or replace with `@here` (online members only) or a role mention like `<@&ROLE_ID>`.

### Feature Release

```
# 🚀 New Feature: [Feature Name] @everyone

We just shipped **[feature name]** — here's what it does:

- **[Benefit 1]** — brief description
- **[Benefit 2]** — brief description
- **[Benefit 3]** — brief description

> Try it now: [instructions or link]

-# Released [date] • Questions? Ask in <#CHANNEL_ID>
```

### Maintenance Notice

```
# ⚠️ Scheduled Maintenance @everyone

**When:** <t:UNIX_TIMESTAMP:F> (<t:UNIX_TIMESTAMP:R>)
**Duration:** ~[X] minutes
**Impact:** [what will be unavailable]

> We'll update this channel when maintenance is complete.

-# Last updated <t:UNIX_TIMESTAMP:R>
```

### App / Product Launch

```
# 🎊 [App Name] is Live! @everyone

After [X months/weeks] of building, **[App Name]** is officially available on [platforms].

### What is it?
[One paragraph elevator pitch]

### Key Features
- **[Feature 1]** — [short description]
- **[Feature 2]** — [short description]
- **[Feature 3]** — [short description]

### Download / Try It
- 📱 iOS: [link]
- 🤖 Android: [link]
- 🌐 Web: [link]

> 🐛 Found a bug? Report it in <#CHANNEL_ID>
> 💡 Feature request? Drop it in <#CHANNEL_ID>

-# Built by <@USER_ID> • v1.0.0
```

### Giveaway / Contest

```
# 🎁 GIVEAWAY: [Prize Name] @everyone

**Prize:** [description of what they win]
**Winners:** [X] winner(s)
**Ends:** <t:UNIX_TIMESTAMP:F> (<t:UNIX_TIMESTAMP:R>)

### How to Enter
1. React to this message with 🎉
2. [Optional: Follow @account]
3. [Optional: Invite a friend]

### Rules
- Must be a member of this server
- One entry per person
- Winner announced in <#CHANNEL_ID>

> *No purchase necessary. ||Winner selected randomly via [tool].||*

-# Hosted by <@USER_ID> • Good luck!
```

### Sale / Discount

```
# 💰 [Sale Name] — [X]% Off
@everyone

**What:** [product/service] is on sale
**Discount:** [details — code, automatic, etc.]
**Expires:** <t:UNIX_TIMESTAMP:F> (<t:UNIX_TIMESTAMP:R>)

> 🛒 **Grab it here:** [link]

-# Limited time • No stacking with other offers
```

### Hiring / Open Position

```
# 📢 We're Hiring: [Role Title] @everyone

**Team:** [team name]
**Type:** [Full-time / Part-time / Contract]
**Location:** [Remote / City / Hybrid]
**Compensation:** [range or "competitive"]

### What You'll Do
- [Responsibility 1]
- [Responsibility 2]
- [Responsibility 3]

### What We're Looking For
- [Requirement 1]
- [Requirement 2]
- [Nice-to-have]

### How to Apply
> [Instructions — DM, link, email, etc.]

-# Applications close <t:UNIX_TIMESTAMP:D> • Questions? Ask <@USER_ID>
```

## Community & Moderation

### Rules / Guidelines

```
# 📋 Server Rules

### 1. Be Respectful
Treat everyone with dignity. No harassment, hate speech, or personal attacks.

### 2. Stay On Topic
Use the right channels. Check <id:browse> to find the right place.

### 3. No Spam
No unsolicited DMs, repeated messages, or self-promotion without permission.

### 4. Follow Discord TOS
> https://discord.com/terms

-# Updated <t:UNIX_TIMESTAMP:D> • Violations may result in mute or ban
```

### Welcome Message

```
# 👋 Welcome to [Server Name]!

Hey <@USER_ID>, glad you're here! Here's how to get started:

1. Read the rules in <#CHANNEL_ID>
2. Grab your roles in <id:customize>
3. Introduce yourself in <#CHANNEL_ID>
4. Check out <id:guide> for a full walkthrough

> **Need help?** Ping <@&ROLE_ID> anytime.
```

### Role Directory

```
# 🏷️ Role Directory

### Staff
- <@&ROLE_ID> — Server owner and administrators
- <@&ROLE_ID> — Community moderators

### Member Tiers
- <@&ROLE_ID> — New members (default)
- <@&ROLE_ID> — Active contributors (earned at [criteria])
- <@&ROLE_ID> — Veteran members (earned at [criteria])

### Opt-In Roles
Grab these in <id:customize>:
- <@&ROLE_ID> — Get pinged for [topic]
- <@&ROLE_ID> — Get pinged for [topic]
- <@&ROLE_ID> — Get pinged for [topic]

-# Roles managed by <@&ROLE_ID>
```

### Warning / Strike Notice

```
## ⚠️ Moderation Notice

**User:** <@USER_ID>
**Action:** [Verbal Warning / Mute / Temp Ban / Ban]
**Duration:** [if applicable]
**Reason:** [brief description of violation]

**Rule violated:** Rule #[X] — [rule name]

> [Quote of offending message or description of behavior]

-# Logged by <@USER_ID> • <t:UNIX_TIMESTAMP:f> • Strike [X] of [Y]
```

### Application / Form Template

```
# 📝 [Role/Position] Application

Copy this template and DM it to <@USER_ID> or post in <#CHANNEL_ID>.

```

**Discord Username:**
**Timezone:**
**Age (if required):**

**Why are you interested?**
[Your answer]

**Relevant experience:**
[Your answer]

**How active are you?**
[Your answer]

**Anything else we should know?**
[Your answer]

```

-# Applications reviewed within [X] days
```

### Partnership / Collab Request

```
## 🤝 Partnership Proposal

**Server/Brand:** [name]
**Size/Reach:** [member count, followers, etc.]
**Website:** [link]

### What We're Proposing
[Description of partnership — cross-promotion, event collab, shared project, etc.]

### What We Bring
- [Value 1]
- [Value 2]

### What We're Looking For
- [Value 1]
- [Value 2]

> **Interested?** DM <@USER_ID> or reply below.

-# Submitted <t:UNIX_TIMESTAMP:D>
```

### Server Boost Acknowledgment

```
# 💎 Thank You, Boosters!

Our server is at **Level [1/2/3]** with **[X] boosts** thanks to these legends:

<@USER_ID> • <@USER_ID> • <@USER_ID>

### Current Perks Unlocked
- ✅ [Perk 1 — e.g., 128kbps audio]
- ✅ [Perk 2 — e.g., custom banner]
- ✅ [Perk 3 — e.g., 50 emoji slots]

### Next Level ([X] more boosts)
- ⬜ [Next perk]
- ⬜ [Next perk]

-# Boost perks: https://discord.com/nitro
```

## Development & Technical

### Bug Report Template

````
## 🐛 Bug Report

**Summary:** [one-line description]

**Steps to Reproduce:**
1. Go to [location]
2. Click on [element]
3. Observe [unexpected behavior]

**Expected:** [what should happen]
**Actual:** [what happens instead]

**Environment:**
- OS: [e.g., Windows 11, macOS 14]
- Version: [e.g., v1.2.3]
- Browser: [if applicable]

```error log
paste relevant error output here
````

-# Reported by @username • <t:UNIX_TIMESTAMP:d>

```

### Code Review / PR Summary
```

## 📝 PR Summary: [PR Title]

**Branch:** `feature/branch-name` → `main`
**Changes:** [brief description]

### What Changed

- **[File/Area]** — [description of change]
- **[File/Area]** — [description of change]

### Testing

```bash
npm test           # ✅ All passing
npm run lint       # ✅ No warnings
npm run typecheck  # ✅ Clean
```

> **Review link:** [URL]

-# Ready for review • cc <@USER_ID>

```

### Changelog
```

# 📦 v[X.Y.Z] Changelog

### ✨ New

- [Feature description]
- [Feature description]

### 🐛 Fixes

- Fixed [issue description]
- Fixed [issue description]

### 🔧 Changes

- [Change description]
- [Change description]

### ⚠️ Breaking

- [Breaking change] — see ||migration guide in #channel||

-# Full diff: [link to release]

```

### API / Integration Docs
```

## 🔌 [API/Integration Name]

**Base URL:** `https://api.example.com/v1`
**Auth:** [API key / OAuth / Bearer token]
**Docs:** [link]

### Quick Start

```bash
curl -X GET https://api.example.com/v1/endpoint \
  -H "Authorization: Bearer YOUR_TOKEN"
```

### Common Endpoints

- `GET /resource` — list all
- `GET /resource/:id` — get one
- `POST /resource` — create
- `PATCH /resource/:id` — update

### Rate Limits

| Tier | Requests/min |
| ---- | ------------ |
| Free | 60           |
| Pro  | 300          |

> ❓ Issues? Post in <#CHANNEL_ID> with your error code.

-# Last updated <t:UNIX_TIMESTAMP:D>

```

### Outage / Incident Report
```

# 🔴 Incident Report: [Brief Title]

**Status:** 🔴 Investigating / 🟡 Identified / 🟢 Resolved
**Start:** <t:UNIX_TIMESTAMP:F>
**Resolved:** <t:UNIX_TIMESTAMP:F> / _ongoing_
**Duration:** [X hours/minutes]

### What Happened

[Clear explanation of the issue]

### Impact

[Who/what was affected]

### Timeline

- <t:TIMESTAMP:t> — [Event: issue detected]
- <t:TIMESTAMP:t> — [Event: root cause identified]
- <t:TIMESTAMP:t> — [Event: fix deployed]
- <t:TIMESTAMP:t> — [Event: confirmed resolved]

### Root Cause

||[Technical explanation — spoiler-tagged for non-technical readers]||

### Next Steps

- [ ] [Preventative measure 1]
- [ ] [Preventative measure 2]

-# Report by <@USER_ID> • Post-mortem in <#CHANNEL_ID>

```

### Feature Request Template
```

## 💡 Feature Request

**Title:** [Short, descriptive name]
**Priority:** 🔴 High / 🟡 Medium / 🟢 Low

### Problem

[What problem does this solve? Who has this problem?]

### Proposed Solution

[How should it work?]

### Alternatives Considered

[Other approaches you thought about]

### Additional Context

> [Mockups, screenshots, examples, or references]

-# Vote with 👍 if you want this • Submitted <t:UNIX_TIMESTAMP:d>

```

### Tech Stack / Architecture Overview
```

# 🏗️ Tech Stack

### Frontend

- **Framework:** [e.g., React Native / Expo]
- **Language:** [e.g., TypeScript]
- **Styling:** [e.g., NativeWind / Tailwind]

### Backend

- **Runtime:** [e.g., .NET 8]
- **Database:** [e.g., PostgreSQL via Supabase]
- **Auth:** [e.g., Supabase Auth]

### Infrastructure

- **Hosting:** [e.g., Cloudflare Workers]
- **CI/CD:** [e.g., GitHub Actions]
- **Monitoring:** [e.g., Sentry]

### Dev Tools

- `[tool]` — [purpose]
- `[tool]` — [purpose]
- `[tool]` — [purpose]

-# Updated <t:UNIX_TIMESTAMP:D> • Maintained by <@USER_ID>

```

## Events & Scheduling

### Event Announcement
```

# 🎉 [Event Name]

**When:** <t:UNIX_TIMESTAMP:F> (<t:UNIX_TIMESTAMP:R>)
**Where:** [location / voice channel / link]
**What:** [description]

### Schedule

- <t:TIMESTAMP_1:t> — [Activity 1]
- <t:TIMESTAMP_2:t> — [Activity 2]
- <t:TIMESTAMP_3:t> — [Activity 3]

> **RSVP:** React with ✅ if you're coming!

-# Hosted by <@USER_ID>

```

### AMA (Ask Me Anything)
```

# 🎤 AMA with [Guest Name]

**Who:** [Brief bio — title, known for, etc.]
**When:** <t:UNIX_TIMESTAMP:F> (<t:UNIX_TIMESTAMP:R>)
**Where:** <#CHANNEL_ID>

### How It Works

1. Drop your questions in this thread **before** the event
2. Upvote questions you want answered (react 👍)
3. [Guest] will answer live starting at <t:UNIX_TIMESTAMP:t>

### Topics They Can Cover

- [Topic 1]
- [Topic 2]
- [Topic 3]

> _Please keep questions respectful and on-topic._

-# Organized by <@USER_ID>

```

### Recurring Meeting / Standup
```

## 📅 [Meeting Name] — <t:UNIX_TIMESTAMP:D>

**Time:** <t:UNIX_TIMESTAMP:t> (<t:UNIX_TIMESTAMP:R>)
**Voice:** <#CHANNEL_ID>
**Agenda:** [link or see below]

### Agenda

1. [Topic 1] — [owner]
2. [Topic 2] — [owner]
3. Open floor

### Action Items from Last Meeting

- ✅ [Completed item] — <@USER_ID>
- 🔄 [In progress item] — <@USER_ID>
- ❌ [Not started] — <@USER_ID>

> Can't make it? Post your async update below.

-# Next meeting: <t:UNIX_TIMESTAMP:D>

```

### Workshop / Tutorial Session
```

# 🎓 Workshop: [Topic]

**Instructor:** <@USER_ID>
**When:** <t:UNIX_TIMESTAMP:F> (<t:UNIX_TIMESTAMP:R>)
**Duration:** ~[X] minutes
**Skill Level:** 🟢 Beginner / 🟡 Intermediate / 🔴 Advanced

### What You'll Learn

- [Outcome 1]
- [Outcome 2]
- [Outcome 3]

### Prerequisites

- [Requirement 1 — e.g., Node.js installed]
- [Requirement 2 — e.g., basic JavaScript knowledge]

### Prep Work

> [Links to pre-read material, repos to clone, tools to install]

### Resources

- 📂 Repo: [link]
- 📝 Slides: [link]
- 🎥 Recording: _posted after the session_

-# React ✅ to reserve your spot • Limited to [X] attendees

```

### Game Night / Social Event
```

# 🎮 Game Night: [Game Name]

**When:** <t:UNIX_TIMESTAMP:F> (<t:UNIX_TIMESTAMP:R>)
**Where:** <#CHANNEL_ID> voice
**Game:** [name] — [free/paid, platform]
**Players:** [min]-[max]

### How to Join

1. React ✅ below to sign up
2. Join <#CHANNEL_ID> at game time
3. [Any setup instructions — download, account, etc.]

> 🏆 **Prize:** [optional — bragging rights, role, etc.]

-# Hosted by <@USER_ID> • Casual vibes, all skill levels welcome

```

## Informational

### FAQ Entry
```

### ❓ [Question goes here?]

[Clear, concise answer.]

> **Example:**
> [example or demonstration]

-# See also: <#CHANNEL_ID>

```

### Status Update
```

## 📊 Status Update — [Project/Topic]

**Status:** 🟢 On Track / 🟡 At Risk / 🔴 Blocked

### Completed

- ✅ [Task 1]
- ✅ [Task 2]

### In Progress

- 🔄 [Task 3] — [brief status]
- 🔄 [Task 4] — [brief status]

### Blocked

- ❌ [Task 5] — blocked by [reason]

> **Next milestone:** <t:UNIX_TIMESTAMP:D>

-# Updated <t:UNIX_TIMESTAMP:R>

```

### Weekly Digest / Newsletter
```

# 📰 Weekly Digest — [Date Range]

### 🔥 Highlights

- [Big thing that happened this week]
- [Another notable event]

### 📈 Stats

- **New members:** [X]
- **Messages:** [X]
- **Most active channel:** <#CHANNEL_ID>

### 📝 Content Roundup

- [Article/video/resource] by <@USER_ID> — [brief description]
- [Article/video/resource] by <@USER_ID> — [brief description]

### 🗓️ Upcoming

- <t:TIMESTAMP:D> — [Event 1]
- <t:TIMESTAMP:D> — [Event 2]

### 💬 Quote of the Week

> "[memorable thing someone said]" — <@USER_ID>

-# Compiled by <@USER_ID> • See past digests in <#CHANNEL_ID>

```

### Tutorial / How-To Guide
```

# 📖 How to [Do the Thing]

### Overview

[1-2 sentence summary of what this guide covers]

### Step 1: [Action]

[Detailed instructions]

```
optional code block or example
```

### Step 2: [Action]

[Detailed instructions]

> 💡 **Tip:** [helpful tip for this step]

### Step 3: [Action]

[Detailed instructions]

### Common Issues

**Problem:** [description]
**Fix:** [solution]

**Problem:** [description]
**Fix:** [solution]

-# Written by <@USER_ID> • Feedback? Reply in thread

```

### Resource Collection / Link List
```

# 📚 [Topic] Resources

### Getting Started

- [Resource Name](URL) — [brief description]
- [Resource Name](URL) — [brief description]

### Intermediate

- [Resource Name](URL) — [brief description]
- [Resource Name](URL) — [brief description]

### Advanced

- [Resource Name](URL) — [brief description]
- [Resource Name](URL) — [brief description]

### Tools

- `[tool name]` — [what it does] — [link]
- `[tool name]` — [what it does] — [link]

> 📌 Have a resource to add? Reply in thread.

-# Curated by <@USER_ID> • Last updated <t:UNIX_TIMESTAMP:D>

```

### Feedback / Survey Request
```

# 📣 We Need Your Feedback!

**Topic:** [What you're gathering feedback on]
**Deadline:** <t:UNIX_TIMESTAMP:F> (<t:UNIX_TIMESTAMP:R>)

### Context

[Why are you asking? What will the feedback be used for?]

### Questions

1. [Question 1]
2. [Question 2]
3. [Question 3]

> **How to respond:** [Reply in thread / Fill out form / React below]
> 📋 **Form link:** [link if applicable]

-# All feedback is [anonymous/attributed] • Results shared in <#CHANNEL_ID>

```

### Pricing / Tier Comparison
```

# 💎 [Product/Service] Plans

### 🟢 Free

- [Feature 1]
- [Feature 2]
- [Limitation]

### 🔵 Pro — $[X]/mo

- Everything in Free, plus:
- [Feature 3]
- [Feature 4]
- [Higher limit]

### 🟣 Enterprise — Contact us

- Everything in Pro, plus:
- [Feature 5]
- [Feature 6]
- [Custom support]

> 🛒 **Get started:** [link]
> ❓ **Questions:** <#CHANNEL_ID> or DM <@USER_ID>

-# Prices in USD • Updated <t:UNIX_TIMESTAMP:D>

```

### Onboarding Checklist
```

# ✅ [Server/Project] Onboarding

Welcome! Complete these steps to get set up:

### Account Setup

- [ ] Read server rules in <#CHANNEL_ID>
- [ ] Grab your roles in <id:customize>
- [ ] Set your server nickname to [format]

### Get Connected

- [ ] Introduce yourself in <#CHANNEL_ID>
- [ ] Join the <#CHANNEL_ID> voice chat
- [ ] Follow <#CHANNEL_ID> for updates

### [Project-Specific]

- [ ] Clone the repo: `git clone [URL]`
- [ ] Set up your environment: see <#CHANNEL_ID>
- [ ] Say hi in <#CHANNEL_ID>

> **Stuck?** Ping <@&ROLE_ID> — we don't bite. Usually.

-# Last updated <t:UNIX_TIMESTAMP:D>

```

## Social Media & Content

### Content Drop / Creator Post
```

# 🎬 New [Video/Article/Podcast]: [Title]

**By:** <@USER_ID>
**Link:** [URL]
**Length:** [duration / read time]

### What It Covers

[2-3 sentence summary of the content]

> 💬 **Discussion:** React with your thoughts or reply in thread!

-# Posted <t:UNIX_TIMESTAMP:R> • Support the creator: [link]

```

### Social Media Cross-Post
```

## 📱 Follow Us Everywhere

Stay in the loop across all platforms:

- 🐦 **X/Twitter:** [@handle](https://x.com/handle)
- 📸 **Instagram:** [@handle](https://instagram.com/handle)
- 📺 **YouTube:** [Channel Name](https://youtube.com/@handle)
- 💼 **LinkedIn:** [Page Name](https://linkedin.com/company/name)
- 🌐 **Website:** [domain.com](https://domain.com)
- 📧 **Newsletter:** [Subscribe](https://link)

> 🔔 Turn on notifications so you never miss an update!

-# Links verified <t:UNIX_TIMESTAMP:D>

```

### Testimonial / Social Proof
```

# ⭐ What People Are Saying

> "[Testimonial quote 1]"
> — **[Name]**, [Title/Context]

> "[Testimonial quote 2]"
> — **[Name]**, [Title/Context]

> "[Testimonial quote 3]"
> — **[Name]**, [Title/Context]

-# Want to share your experience? DM <@USER_ID>

```

## Marketplace & Services

### Commission / Service Listing
```

# 🎨 [Service Type] — Open for Commissions

**Artist/Provider:** <@USER_ID>
**Portfolio:** [link]

### Tiers

- **Basic** — $[X] — [what's included]
- **Standard** — $[X] — [what's included]
- **Premium** — $[X] — [what's included]

### Turnaround

- Basic: [X] days
- Standard: [X] days
- Premium: [X] days

### Terms

- [Payment method — PayPal, etc.]
- [Revision policy]
- [Usage rights]

> **To order:** DM <@USER_ID> with [details needed]

-# Slots: [X] open • Status: 🟢 Open / 🔴 Closed

```

### Marketplace Listing
```

## 🏷️ [For Sale / For Trade / Free]

**Item:** [name/description]
**Condition:** [New / Used / Digital]
**Price:** $[X] / [trade for...] / Free
**Shipping:** [included / buyer pays / digital delivery]

[Optional: photo or screenshot link]

> **Interested?** React ✋ or DM <@USER_ID>

-# Listed <t:UNIX_TIMESTAMP:R> • [Server marketplace rules apply]

```

## Formatting Tricks

### Separator Line
Discord doesn't support `---` for horizontal rules. Use an empty block quote or code block as a visual separator:
```

\_ \_

```
Or use a unicode line:
```

─────────────────────

```

### Invisible Spacing
Use `_ _` (underscore, space, underscore) for an empty line that Discord won't collapse:
```

Line 1
\_ \_
Line 3 (with visible gap above)

```

### Color-Coded Text via Code Blocks
Discord doesn't support colored text natively, but `diff` blocks give you colored lines:
```

```diff
+ This line is green (added)
- This line is red (removed)
! This line is orange (in some themes)
# This line is gray (comment)
```

```

### Table-Like Formatting
Discord doesn't render markdown tables. Use code blocks for alignment:
```

```
Name        Role          Status
────────    ──────────    ────────
Alice       Admin         ✅ Online
Bob         Moderator     ⚫ Offline
Charlie     Member        🟡 Idle
```

````

### Embed-Like Formatting
Mimic embed styling using block quotes and formatting:
```
> ## 📌 Important Notice
>
> This is how you can simulate an embed-like
> appearance using block quotes and headers.
>
> **Field 1:** Value
> **Field 2:** Value
>
> *Footer text here*
```

### Progress Bar
Create visual progress bars using Unicode characters:
```
**Level Progress**
▓▓▓▓▓▓▓▓░░ 80%

**Upload Status**
█████████░ 90% complete
```

### Collapsible Content (Spoiler Sections)
Use spoiler tags to create expandable sections:
```
### Answers
||1. Answer to question one||
||2. Answer to question two||
||3. Answer to question three||

*Click to reveal each answer*
```

### Multi-Column Layout
Approximate columns with inline code and spacing:
````

```
🟢 ONLINE        🟡 IDLE          🔴 DND
───────────      ───────────      ───────────
Alice            Charlie          Eve
Bob              David            Frank
```

````

### Timestamp Quick Reference
Generate timestamps at [hammertime.cyou](https://hammertime.cyou) or [discordtimestamp.com](https://discordtimestamp.com):
```
Short time:    <t:1700000000:t>  →  2:13 PM
Long time:     <t:1700000000:T>  →  2:13:20 PM
Short date:    <t:1700000000:d>  →  11/14/2023
Long date:     <t:1700000000:D>  →  November 14, 2023
Full:          <t:1700000000:F>  →  November 14, 2023 2:13 PM
Relative:      <t:1700000000:R>  →  2 months ago
```

````
