---
name: discord-hub
description: OpenClaw skill for Discord Bot API workflows, covering interactions, commands, messages, and operations using direct HTTPS requests.
---

# Discord Bot API Skill (Advanced)

## Purpose
Provide a production-oriented guide for building Discord bot workflows via the REST API and Interactions, focusing on professional command UX, safe operations, and direct HTTPS usage (no SDKs).

## Best fit
- You want command-first bot behavior and clear interaction flows.
- You prefer direct HTTP requests without a library dependency.
- You need a structured map of Discord API surfaces.

## Not a fit
- You need a full SDK or gateway client implementation.
- You plan to stream large media uploads directly.

## Quick orientation
- Read `references/discord-api-overview.md` for base URL, versioning, and object map.
- Read `references/discord-auth-and-tokens.md` for token types and security boundaries.
- Read `references/discord-interactions.md` for interaction lifecycle and response patterns.
- Read `references/discord-app-commands.md` for slash, user, and message commands.
- Read `references/discord-messages-components.md` for messages, embeds, and components.
- Read `references/discord-gateway-webhooks.md` for gateway vs webhook tradeoffs.
- Read `references/discord-rate-limits.md` for throttling and header-based handling.
- Read `references/discord-request-templates.md` for HTTP payload templates.
- Read `references/discord-feature-map.md` for the full surface checklist.

## Required inputs
- Bot token and application ID.
- Interaction endpoint public key (if using interaction webhooks).
- Command list and UX tone.
- Allowed intents and event scope.

## Expected output
- A clear bot workflow plan, command design, and operational checklist.

## Operational notes
- Prefer interactions and slash commands over prefix parsing.
- Always validate incoming interaction signatures.
- Keep payloads small and respond quickly to interactions.

## Security notes
- Never log tokens or secrets.
- Use least-privilege permissions and scopes.
