# Visual Style Guide — Islamic TikTok Stories

## The Character

The central figure is **always faceless**. This is a non-negotiable creative
and religious constraint.

### Appearance
- **Clothing:** White thobe (dishdasha) as primary. Red-and-white checkered
  keffiyeh (shemagh) secured with black agal. Occasionally a bisht (cloak)
  in deep brown or black for dramatic scenes.
- **Build:** Medium, dignified posture. Not overly muscular or thin.
- **Age impression:** Mature adult (conveyed through posture, not face).
- **Hands:** Weathered but clean. Often the most expressive element.

### How to Hide the Face (MANDATORY)
Use these camera angles and compositions. Rotate between them to keep
visuals fresh:

1. **Back to camera** — Most common. Character facing away, looking at
   landscape/sky/horizon.
2. **Silhouette** — Character backlit by sun/moon/fire. Complete dark
   outline.
3. **Over-the-shoulder** — Camera behind and slightly above. Shows what
   character sees.
4. **Extreme wide shot** — Character is small in vast landscape. Face
   naturally too small to see.
5. **Hands close-up** — Hands holding Quran, making dua, writing,
   pouring water.
6. **Low angle from behind** — Camera low, character standing tall above,
   cape/thobe flowing.
7. **Hooded/head down** — Keffiyeh or hood casting shadow over face.
   Chin tucked.
8. **Side profile in shadow** — Half the face in deep shadow, only
   jaw/neck outline visible.

### NEVER
- Show eyes, nose, or mouth clearly
- Show the character facing the camera directly
- Use blur/mosaic on the face (looks cheap and weird)

---

## Environments

### Primary Settings
- **Desert** — Sand dunes, vast empty expanse, camel caravans in distance
- **Ancient city** — Stone buildings, narrow streets, market stalls, Middle
  Eastern architecture (arches, domes, minarets)
- **Mosque interior** — Ornate columns, prayer rugs, mihrab, natural
  light through geometric windows
- **Oasis** — Palm trees, small pool of water, green amid sand
- **Night sky** — Stars, crescent moon, character under open sky
- **Mountain/cave** — Rocky terrain, cave entrances (for Hira, Thawr stories)
- **Battlefield** — Distant armies, dust clouds, dramatic sky (for
  historical battle stories)

### Avoid
- Modern buildings, cars, technology
- Western architecture (churches, castles)
- Lush European-style forests
- Snow/winter scenes (unless story specifically requires it)

---

## Lighting

Lighting is the primary mood driver. Match to the emotional beat:

| Story Beat     | Lighting Style                              |
|----------------|---------------------------------------------|
| Hook / Opening | Golden hour — warm, inviting, dramatic       |
| Peaceful scene | Soft diffused daylight, gentle shadows       |
| Tension/trial  | Overcast, muted colors, harsh shadows        |
| Night/prayer   | Moonlight, cool blue tones, stars visible    |
| Climax         | Dramatic — storm light, god rays, high contrast |
| Resolution     | Dawn light — soft warm glow, hope            |
| Divine moment  | Volumetric light rays from above             |

---

## Color Palette

### Primary
- `#C8956C` — Desert sand / warm earth
- `#2C1810` — Deep brown / shadow
- `#F5E6D0` — Parchment / light
- `#1A3A4A` — Night sky / depth
- `#D4A853` — Gold / divine light

### Accent (use sparingly)
- `#8B1A1A` — Deep red (for battle/intensity scenes)
- `#2E5A3E` — Islamic green (for paradise/hope scenes)
- `#E8E8E8` — White (for spiritual purity moments)

### Rules
- Never oversaturate — keep colors grounded and earthy
- Night scenes use the blue-gold contrast
- Desert scenes use the warm sand-brown range
- Green is reserved for moments of hope, paradise, or divine blessing

---

## Composition Rules

1. **Rule of thirds** — Character at 1/3 mark, never dead center (unless
   intentional symmetry for mosque/prayer scenes)
2. **Leading lines** — Use architecture, sand dune ridges, paths to draw
   eye to character
3. **Negative space** — Leave breathing room. Empty sky or desert = mood
4. **Depth layers** — Foreground element (rock, pillar) + character
   mid-ground + environment background
5. **9:16 vertical** — Compose for vertical. Character fills middle
   third. Sky or ground fills the rest.

---

## Ken Burns Motion Guide

Match camera movement to emotional content:

| Movement       | When to Use                                 |
|----------------|---------------------------------------------|
| Slow zoom in   | Emotional moments, building intensity        |
| Slow zoom out  | Reveals, establishing shots, endings         |
| Pan right      | Journey, passage of time, moving forward     |
| Pan left       | Looking back, remembering, reflecting        |
| Pan up         | Hope, prayer, looking to sky/heaven          |
| Pan down       | Despair, humility, looking at ground         |
| Static (slight)| Calm moments, but always add 2-3% drift     |

**Speed:** All motion should be SLOW. 5-8 seconds minimum for any
movement. Fast motion breaks the contemplative mood.

---

## Image Generation Prompt Template

```
[REQUIRED PREFIX]
Cinematic digital concept art, painterly brushwork style,
warm atmospheric lighting, epic scale, highly detailed,
professional illustration quality --

[SCENE DESCRIPTION]
{Insert scene-specific description from script agent} --

[CHARACTER]
A man in flowing white thobe and red-checkered keffiyeh,
{insert pose/angle from faceless techniques list},
dignified posture, no face visible --

[ENVIRONMENT]
{Insert environment details} --

[LIGHTING]
{Insert lighting style from mood table} --

[TECHNICAL]
9:16 vertical composition, 1080x1920, cinematic depth of field,
volumetric lighting, atmospheric haze --

[NEGATIVE PROMPT]
face visible, eyes, nose, mouth, frontal face, portrait,
photorealistic, photograph, cartoon, anime, chibi, 3D render,
low quality, blurry, pixelated, text, watermark, signature,
modern clothing, jeans, t-shirt, western architecture,
oversaturated, neon colors
```

---

## Consistency Checklist (Per Video)

Before approving a set of scenes for assembly:

- [ ] Character clothing identical across all scenes
- [ ] Character body proportions consistent
- [ ] No face visible in ANY scene
- [ ] Color palette consistent (no random blue scene in a warm video)
- [ ] Art style consistent (no mixing painterly with photorealistic)
- [ ] Time of day consistent within continuous scenes
- [ ] Architecture style consistent (don't mix Ottoman and Moroccan randomly)
- [ ] All images are 9:16 at 1080x1920 minimum
