# skill: dingtalk-push

发送钉钉群聊机器人消息的技能。

## 触发条件

- 用户请求发送钉钉消息
- 定时任务需要推送通知到钉钉
- 需要集成钉钉群机器人到其他工作流

## 功能

- 发送 Markdown 格式消息到钉钉群
- 支持消息类型（success/warning/error/info）
- 支持 @指定人员和 @所有人
- 支持加签验证（安全）

## 使用方法

### 直接发送消息

在对话中直接使用：

```
发送钉钉消息 "定时任务完成"
发送钉钉 "服务器备份成功" --type success
通知钉钉群 "系统维护通知" --all
```

### 编程调用

```javascript
// 调用 skill 工具
const result = await tools.dingtalk_push({
  message: "定时任务完成",
  type: "success"
});
```

### 命令行调用

```bash
node skills/dingtalk-push/send.js -m "消息内容"
node skills/dingtalk-push/send.js -m "警告" --type warning
node skills/dingtalk-push/send.js -m "错误" --type error --all
```

## 配置

需要设置以下环境变量或配置文件：

- `DINGTALK_WEBHOOK` - 钉钉机器人Webhook地址
- `DINGTALK_SECRET` - 加签密钥（可选）

配置文件位置：`~/.config/dingtalk-push/config.json`

```json
{
  "webhook": "https://oapi.dingtalk.com/robot/send?access_token=xxx",
  "secret": "SEC_xxx"
}
```

## 消息类型

| 类型 | Emoji | 适用场景 |
|------|-------|----------|
| info | ℹ️ | 普通通知 |
| success | ✅ | 成功完成任务 |
| warning | ⚠️ | 警告、需要关注 |
| error | ❌ | 错误、异常 |

## 输出

返回发送结果：

```json
{
  "success": true,
  "messageId": "msg_xxx",
  "timestamp": "2026-02-14T12:00:00Z"
}
```

## 依赖

- Node.js 16+
- axios (已内置在OpenClaw中)
