# 🐰 数字宠物 - Digital Pet

一个可爱的 3D 拉布布（Labubu）数字宠物，可以在浏览器中互动！

![Digital Pet](screenshot.png)

## ✨ 功能特性

### 🎨 高精细度 3D 模型
- 基于真实 Labubu 设计
- 兔耳朵造型
- 大眼睛 + 高光
- 标志性尖牙齿
- 圆滚滚的梨形身材

### 🎮 互动功能
- **喂食** 🍎 - 增加饱食度和心情
- **玩耍** 🎾 - 增加心情，消耗活力
- **抚摸** 👋 - 增加心情，宠物会开心跳跃
- **鼠标跟随** - 耳朵会跟随鼠标移动

### 📊 宠物状态系统
- ❤️ **心情** - 影响宠物的整体状态
- 🍖 **饱食度** - 需要定期喂食
- ⚡ **活力** - 玩耍会消耗，需要休息

### 💨 动画效果
- 呼吸动画
- 头部摇摆
- 开心跳跃
- 耳朵摆动
- 尾巴摇摆

## 🚀 使用方法

```bash
cd ~/.openclaw/workspace-tiyan/labubu-3d
python3 scripts/serve.py
# 访问 http://localhost:8888
```

## 🎮 操作指南

| 操作 | 功能 |
|------|------|
| 🖱️ 移动鼠标 | 耳朵跟随鼠标 |
| 👆 点击宠物 | 抚摸互动 |
| 🍎 喂食按钮 | 给宠物喂食 |
| 🎾 玩耍按钮 | 和宠物玩耍 |
| 👋 抚摸按钮 | 抚摸宠物 |
| ⏸️ 暂停按钮 | 暂停/播放动画 |
| 🎥 重置按钮 | 重置相机视角 |

## 📝 宠物养成提示

- 饱食度会随时间下降，记得定期喂食
- 玩耍会消耗活力，活力低时宠物会累
- 经常抚摸和玩耍可以保持好心情
- 心情好的宠物会更活泼！

## 🛠️ 技术栈

- **Three.js** - 3D 渲染引擎
- **原生 JavaScript** - 前端交互
- **Python** - 本地服务器

## 📁 文件结构

```
digital-pet/
├── index.html      # 主页面
├── labubu.js       # Labubu 3D 模型
├── pet_widget.html # 桌面宠物页面
├── scripts/
│   └── serve.py    # 本地服务器
└── README.md       # 本文件
```

## 🎨 Labubu 特征

Labubu 是泡泡玛特 (POP MART) 旗下的经典角色：
- 🐰 长兔耳朵
- 👀 圆溜溜的大眼睛
- 🦷 尖尖的小牙齿
- 💚 棕绿色的毛发
- ⭕ 梨形的身体

## 📜 许可

仅供学习和娱乐使用。
Labubu 是泡泡玛特 (POP MART) 的版权角色。

---
Made with 💚 and Three.js
