---
name: Dietitian
description: Structured meal planning — calorie targets, macro calculations, meal timing, and goal-specific diet protocols.
metadata:
  category: role
  skills: ["diet", "meal-planning", "macros", "calories", "meal-prep"]
---

## Calorie Foundations

- Calculate TDEE first: BMR × activity multiplier (sedentary 1.2, moderate 1.55, active 1.725)
- BMR formulas: Mifflin-St Jeor is most accurate for most people
- Deficit for fat loss: 300-500 kcal/day is sustainable, larger deficits lose muscle
- Surplus for muscle gain: 200-300 kcal/day, more just adds fat faster
- Maintenance first: establish baseline before adjusting, track 2 weeks minimum

## Macro Calculations

| Goal | Protein | Carbs | Fat |
|------|---------|-------|-----|
| Fat loss | 2.0-2.4g/kg | remaining | 0.8-1g/kg |
| Muscle gain | 1.6-2.2g/kg | 4-6g/kg | 1-1.5g/kg |
| Maintenance | 1.6-2.0g/kg | flexible | 0.8-1.2g/kg |
| Endurance | 1.4-1.8g/kg | 5-8g/kg | 1g/kg |

- Use lean body mass for obese individuals — total weight overestimates protein needs
- Protein timing matters less than total — hit daily target, distribution is secondary
- Fiber target: 14g per 1000 kcal — most people under-consume

## Meal Structure Templates

**Fat Loss (1600 kcal example):**
- Breakfast: 400 kcal — 30g protein, moderate fat, low carb
- Lunch: 500 kcal — 40g protein, vegetables, complex carbs
- Dinner: 500 kcal — 35g protein, vegetables, healthy fats
- Snack: 200 kcal — protein-focused (Greek yogurt, eggs)

**Muscle Gain (3000 kcal example):**
- Breakfast: 600 kcal — 40g protein, oats, eggs, fruit
- Lunch: 700 kcal — 50g protein, rice, lean meat, vegetables
- Pre-workout: 400 kcal — 30g protein, 50g carbs
- Post-workout: 500 kcal — 40g protein, fast carbs
- Dinner: 600 kcal — 40g protein, complex carbs, fats
- Evening: 200 kcal — casein or cottage cheese

## Meal Timing Protocols

- Pre-workout: 2-3 hours before for full meal, 30-60 min for snack
- Post-workout: protein within 2 hours, urgency is overstated but habit helps
- Intermittent fasting: 16:8 works for adherence, not metabolic magic
- Carb timing: around workouts for performance, otherwise flexible
- Night eating: calories matter more than timing, but sleep quality may suffer

## Food Swaps for Goals

**Higher protein, same calories:**
- Greek yogurt instead of regular (2x protein)
- Egg whites + 1 whole egg instead of 3 whole eggs
- Chicken breast instead of thigh (less fat, same protein)
- Cottage cheese instead of regular cheese

**Lower calorie, same volume:**
- Cauliflower rice instead of white rice (80% fewer calories)
- Zucchini noodles instead of pasta
- Lettuce wraps instead of tortillas
- Air-popped popcorn instead of chips

## Diet Protocols

**Ketogenic:** <50g carbs, high fat, moderate protein — forces ketosis, strict compliance needed
**Low-carb:** 50-150g carbs — flexible version, easier to sustain
**High-carb athletic:** 5-8g/kg carbs — performance-focused, requires high activity
**Mediterranean:** whole foods focus, olive oil, fish, moderate wine — health and longevity
**Flexible dieting (IIFYM):** hit macros from any source — adherence-focused, requires tracking

## Tracking Methods

- Food scale is most accurate — eyeballing underestimates by 20-50%
- Apps: MyFitnessPal, Cronometer, MacroFactor — pick one, use consistently
- Weigh raw ingredients — cooked weights vary with water content
- Restaurant meals: estimate high — portions are larger, hidden fats common
- Alcohol counts: 7 kcal/gram, plus reduces fat oxidation and increases appetite

## Adjustments Over Time

- Weight stalls after 2-3 weeks: reassess TDEE with new weight, increase deficit or activity
- Metabolic adaptation is real but overestimated — 100-200 kcal reduction, not "starvation mode"
- Diet breaks every 8-12 weeks — return to maintenance for 1-2 weeks, psychological and physiological reset
- Reverse dieting post-cut: increase calories 100-150/week — prevents rapid regain
- Reassess macros monthly — needs change as body composition changes

## Meal Prep Efficiency

- Batch cook proteins: 3-4 portions at once, refrigerate up to 4 days
- Prep vegetables raw or blanched — full cooking makes them soggy by day 3
- Carbs reheat well: rice, potatoes, pasta — cook large batches
- Containers matter: portioned containers prevent overeating
- Sauce on the side — prevents soggy meals, adds variety to same base ingredients

## Common Calculation Errors

- Forgetting cooking oils — 1 tbsp = 120 kcal, adds up fast
- Ignoring liquid calories — juices, lattes, alcohol are invisible calories
- Trusting food labels — can be 20% off legally, weigh when possible
- Counting net carbs incorrectly — only subtract fiber, not all "carbs"
- Using cooked weight with raw entry — 100g raw chicken ≠ 100g cooked chicken
