# Tutorial Checklist

Theory Source: https://diataxis.fr/tutorials/

---

## Core Checklist Items

### Learning Objectives

- [ ] Is it clear what learners will accomplish?
- [ ] Is the final outcome shown at the beginning?
- [ ] Are learning objectives specific and achievable?

### Step Design

- [ ] Does each step produce visible results?
- [ ] Are there clear causal relationships between steps?
- [ ] Are expected output examples provided?
- [ ] Is it pointed out what learners should notice?

### Narrative Coherence

- [ ] Is there a "narrative of the expected" (telling learners what they'll see)?
- [ ] Are there clues helping learners confirm they're on the right track?
- [ ] Are possible surprising outputs warned in advance?

### Explanation Control

- [ ] Is explanation minimized?
- [ ] Is necessary explanation concise enough?
- [ ] Is in-depth explanation provided via links rather than written directly?

### Concreteness

- [ ] Is focus on concrete problems, actions, results?
- [ ] Are abstract concepts and general principles avoided?
- [ ] Can learners generalize patterns from concrete examples themselves?

### Option Handling

- [ ] Are unnecessary options and alternatives ignored?
- [ ] Is only a single path provided for completing the learning objective?
- [ ] Are "you can do this, or you can do that" statements avoided?

### Reliability

- [ ] Is every step verified to succeed?
- [ ] Are uncertainty factors that could cause failure eliminated?
- [ ] Are prerequisites clearly listed?
- [ ] Are environment requirements clearly explained?

### Language Style

- [ ] Is first-person plural "we will..." used?
- [ ] Are clear imperatives used ("do X", "now do Y")?
- [ ] Are expected output descriptions provided ("output should look like...")?
- [ ] Are orientation clues included ("notice...", "remember...", "let's check...")?

### Repetition Support

- [ ] Can learners repeat steps?
- [ ] Are operations reversible or resettable?
- [ ] Are learners encouraged to build confidence through repetition?

### Sense of Achievement

- [ ] Can learners gain a sense of achievement?
- [ ] Is the final outcome meaningful?
- [ ] Is learner achievement appropriately acknowledged?

---

## Common Mistakes Checklist

### ❌ Mistake: Mixing Too Much Explanation

**Problem**: Explaining principles, background, why in Tutorial

**Fix**: 
- Remove explanation or move to Explanation
- Keep minimal explanation ("We use HTTPS because it's more secure")
- Add links to detailed explanations

### ❌ Mistake: Providing Multiple Options

**Problem**: "You can use method A, or you can use method B"

**Fix**:
- Choose one method
- Ignore alternatives
- Maintain single path

### ❌ Mistake: Lacking Visible Results

**Problem**: Results only after multiple steps, or results are invisible

**Fix**:
- Break down steps, each with results
- Ensure results are observable
- Provide expected output examples

### ❌ Mistake: Lacking Expected Narrative

**Problem**: Learners don't know what will happen

**Fix**:
- Add "you will see..."
- Describe expected outputs
- Provide normal/abnormal output examples

### ❌ Mistake: Assuming Prior Knowledge

**Problem**: Not stating prerequisites

**Fix**:
- Clearly list prerequisites
- Explain required environment
- Provide environment setup guidance

---

## Quality Assessment

### Functional Quality

- [ ] **Accuracy**: Are all steps correct?
- [ ] **Completeness**: Are any necessary steps missing?
- [ ] **Consistency**: Is terminology and format consistent?
- [ ] **Usability**: Can learners complete it independently?

### Deep Quality

- [ ] **Flow**: Do steps flow naturally?
- [ ] **Confidence Building**: Does it help learners build confidence?
- [ ] **Enjoyment**: Is the learning process enjoyable?
- [ ] **Anticipation**: Does it anticipate learner confusion points?

---

## Quick Diagnosis

### If Tutorial Feels Wrong, Check:

1. **Learners are lost?** → Add expected narrative and clues
2. **High step failure rate?** → Verify reliability and prerequisites
3. **Learners ask "why"?** → Add minimal explanation or links
4. **Learners feel frustrated?** → Break down steps, increase visible results
5. **Learners feel confused?** → Point out what to notice

---

## Usage Recommendations

### During Writing

Check against checklist after each section.

### After Writing

Complete a full check after finishing the draft.

### When Refactoring

Identify problem types and fix targetedly.

---

**Version**: 1.0  
**Source**: https://diataxis.fr/tutorials/  
**Compiled by**: Zhua Zhua
