# How-to Guide Checklist

Theory Source: https://diataxis.fr/how-to-guides/

---

## Core Checklist Items

### Problem Definition

- [ ] Is the specific problem or goal clearly stated?
- [ ] Is the problem defined from user perspective rather than machine perspective?
- [ ] Does the title accurately describe what the guide shows?

### User Assumptions

- [ ] Is user assumed to have basic competence?
- [ ] Is teaching basic knowledge avoided?
- [ ] Is focus on guiding action rather than teaching?

### Step Design

- [ ] Are steps arranged in logical order?
- [ ] Is real-world complexity considered?
- [ ] Are branches and alternative paths provided (where applicable)?
- [ ] Are different approaches for different scenarios explained?

### Practicality

- [ ] Is the solution executable?
- [ ] Are unnecessary details omitted?
- [ ] Is focus on helping users complete tasks?

### Flow

- [ ] Do steps transition smoothly?
- [ ] Does it match user's thinking and working patterns?
- [ ] Is context switching avoided?
- [ ] Does user need to hold unresolved thoughts for long periods?

### Naming

- [ ] Do titles clearly describe guide content?
- [ ] Is "How to..." format used?
- [ ] Are titles search-engine friendly?

### Language Style

- [ ] Are conditional imperatives used ("if you want X, do Y")?
- [ ] Is lengthy explanation avoided?
- [ ] Are links to Reference provided for complete information?

### Real-World Adaptation

- [ ] Are different environments and scenarios considered?
- [ ] Are prerequisites and dependencies explained?
- [ ] Are possible risks and warnings provided?
- [ ] Is troubleshooting guidance included?

---

## Common Mistakes Checklist

### ❌ Mistake: Writing from Machine Perspective

**Problem**: "To shut off the flow of water, turn the tap clockwise"

**Fix**: 
- Start from user needs
- "To stop the leak, turn the valve clockwise until water flow stops completely"

### ❌ Mistake: Mixing in Tutorial Content

**Problem**: Teaching basic concepts or skills

**Fix**:
- Assume users have basic competence
- Focus on solving specific problems
- Move teaching content to Tutorial

### ❌ Mistake: Mixing in Explanation Content

**Problem**: Explaining why, historical background, principles

**Fix**:
- Remove explanation or move to Explanation
- Keep focus on "how to"
- Link to related explanation documents

### ❌ Mistake: Linear Thinking

**Problem**: Only providing single path, not considering branches

**Fix**:
- Identify different scenarios
- Provide "if X, then Y" branches
- Explain alternatives

### ❌ Mistake: Lacking Context

**Problem**: Assuming users know when to use this

**Fix**:
- Explain applicable scenarios
- Explain inapplicable scenarios
- Provide related guide links

### ❌ Mistake: Vague Titles

**Problem**: "Integrating Application Performance Monitoring"

**Fix**:
- "How to Integrate Application Performance Monitoring"
- "How to Choose the Right Database Configuration"

---

## Quality Assessment

### Functional Quality

- [ ] **Accuracy**: Are steps correct?
- [ ] **Completeness**: Are key scenarios covered?
- [ ] **Consistency**: Is terminology and format consistent?
- [ ] **Usability**: Can users successfully complete tasks?

### Deep Quality

- [ ] **Flow**: Does the guide feel natural like a helper handing you tools?
- [ ] **Anticipation**: Does it anticipate user questions?
- [ ] **Adaptability**: Does it adapt to different use cases?
- [ ] **Trust**: Do users trust this guide?

---

## Quick Diagnosis

### If How-to Feels Wrong, Check:

1. **Users can't complete task?** → Verify step accuracy and completeness
2. **Users ask "when do I use this"?** → Add applicable scenario descriptions
3. **Users encounter unexpected situations?** → Add branches and troubleshooting
4. **Users feel steps are jumpy?** → Add intermediate steps or prerequisite explanations
5. **Users overwhelmed by details?** → Omit non-essential information, link to Reference

---

## Tutorial vs How-to Quick Comparison

| Checkpoint | Tutorial | How-to |
|------------|----------|--------|
| **Goal** | Learning | Complete task |
| **User** | Beginner | Competent user |
| **Explanation** | Minimize | Link to Reference |
| **Path** | Single | Can branch |
| **Responsibility** | Teacher responsible | User responsible |
| **Environment** | Controlled | Real world |

---

## Usage Recommendations

### During Writing

After each section, ask: "Can this help users complete tasks?"

### After Writing

Have target users test and observe if they can complete tasks smoothly.

### When Refactoring

Identify mixed content from other types and separate to corresponding documents.

---

**Version**: 1.0  
**Source**: https://diataxis.fr/how-to-guides/  
**Compiled by**: Zhua Zhua
