# Explanation Checklist

Theory Source: https://diataxis.fr/explanation/

---

## Core Checklist Items

### Understanding-Oriented

- [ ] Is understanding the goal?
- [ ] Is context and background provided?
- [ ] Does it answer "why"?

### Connectivity

- [ ] Are connections to other concepts established?
- [ ] Is a web of understanding woven?
- [ ] Are analogies used to aid understanding?

### Context

- [ ] Is historical background provided?
- [ ] Are design decisions explained?
- [ ] Are technical constraints discussed?
- [ ] Are specific examples mentioned?

### Multiple Perspectives

- [ ] Is the topic discussed from multiple angles?
- [ ] Are different viewpoints acknowledged?
- [ ] Are alternatives weighed?
- [ ] Are differing opinions allowed?

### Boundary Control

- [ ] Are topic boundaries clear?
- [ ] Is instructional content avoided?
- [ ] Is technical description avoided?
- [ ] Is it discursive rather than instructional?

### Language Style

- [ ] Is explanatory language used?
- [ ] Are judgments and opinions appropriately expressed?
- [ ] Is context provided to help readers?
- [ ] Are different approaches weighed?

### Readability

- [ ] Is it suitable for reading away from the product?
- [ ] Can it be "read in the bath"?
- [ ] Does it have discursive flow?

---

## Common Mistakes Checklist

### ❌ Mistake: Mixing in Instruction

**Problem**: "To do X, you should..."

**Fix**: 
- Remove instructional content
- Change to discussing "why X is good"
- Link to How-to

### ❌ Mistake: Mixing in Reference

**Problem**: Pure fact lists, parameter descriptions

**Fix**:
- Add explanation and context
- Discuss "why designed this way"
- Link to Reference

### ❌ Mistake: Unclear Boundaries

**Problem**: Topic scope too large or small

**Fix**:
- Clearly define topic boundaries
- Focus on one "topic"
- Can implicitly have "About..." prefix

### ❌ Mistake: Single Perspective

**Problem**: Only presenting one viewpoint

**Fix**:
- Add multi-angle analysis
- Discuss alternatives
- Acknowledge different opinions

### ❌ Mistake: Lacking Connections

**Problem**: Discussing topic in isolation

**Fix**:
- Establish connections to other concepts
- Use analogies
- Place in larger context

---

## Quality Assessment

### Functional Quality

- [ ] **Accuracy**: Is information accurate?
- [ ] **Completeness**: Are key aspects of the topic covered?
- [ ] **Consistency**: Is the argumentation self-consistent?
- [ ] **Clarity**: Is it easy to understand?

### Deep Quality

- [ ] **Enlightening**: Does it bring new understanding?
- [ ] **Coherence**: Is the argumentation coherent?
- [ ] **Depth**: Is it deep rather than superficial?
- [ ] **Breadth**: Does it cover multiple perspectives?

---

## Quick Diagnosis

### If Explanation Feels Wrong, Check:

1. **Readers ask "how to"?** → Link to How-to
2. **Readers ask "what is"?** → Link to Reference
3. **Discussion boring?** → Add analogies and examples
4. **Difficult to understand?** → Establish more connections
5. **Scope unclear?** → Redefine boundaries

---

## Explanation Writing Patterns

### Historical Background Pattern

```
Topic
├── Origins
├── Development History
├── Key Turning Points
└── Current State
```

### Design Decision Pattern

```
Decision Topic
├── Problem Background
├── Considered Options
├── Final Choice
├── Reasons for Choice
└── Tradeoffs and Compromises
```

### Concept Comparison Pattern

```
Comparison Topic
├── Concept A
├── Concept B
├── Similarities
├── Differences
└── Use Cases
```

### Principle Analysis Pattern

```
Principle Topic
├── Problem Definition
├── Core Mechanism
├── How It Works
├── Influencing Factors
└── Practical Applications
```

---

## Usage Recommendations

### During Writing

Ask: "Can this help readers understand?"

### After Writing

Ask: "Does this explanation allow reflection?"

### When Refactoring

Identify mixed instruction and description, separate to corresponding documents.

---

**Version**: 1.0  
**Source**: https://diataxis.fr/explanation/  
**Compiled by**: Zhua Zhua
