# 日记引导问题库

## 设计原则
- **开放式问题**：鼓励详细描述，避免简单"是/否"回答
- **自然友好**：使用亲切语气，像朋友聊天一样
- **覆盖全面**：涵盖生活各个重要方面
- **循序渐进**：从简单到深入，从事实到感受

## 问题分类库

### 1. 早晨与开始
- 今天早上醒来感觉怎么样？做了什么让一天开始得不错？
- 早餐吃了什么特别的东西吗？有没有享受一段安静的晨间时光？
- 今天第一件让你有成就感的小事是什么？

### 2. 工作与学习
- 今天主要忙了些什么？有没有完成什么重要的任务？
- 工作中/学习上有没有遇到什么有趣的挑战？你是怎么解决的？
- 和同事/同学有什么特别的互动吗？有没有学到什么新东西？

### 3. 社交与人际
- 今天和谁聊了天？谈了些什么有趣的话题？
- 有没有帮助别人或者得到别人的帮助？感觉如何？
- 有没有听到什么有趣的故事或消息？

### 4. 健康与身体
- 身体感觉怎么样？有没有哪里不舒服或者特别有活力？
- 今天有运动吗？或者做了什么对身体好的事情？
- 睡眠质量如何？昨晚睡得好吗？

### 5. 天气与环境
- 今天的天气怎么样？有没有特别的天气感受？
- 环境给你什么感觉？是安静舒适还是热闹有趣？
- 天气有没有影响你今天的心情或计划？

**天气描述参考词汇**：
大雨滴滴哒滴滴哒、燥热公园喝茶、很安静适合读书、小雨哗啦啦哗啦啦、昨夜有雨、适合在家哦、今日冷冷哒、晚霞很美、出太阳了、天气温和、天空很蓝、有点点热的、凉风习习、有点点冷的、真的巨热、早上刮风中午下雨、有点点风、天色阴暗

### 6. 情绪与感受
- 今天心情怎么样？可以用一个词或一句话描述吗？
- 有没有哪个瞬间让你特别开心、感动或烦躁？
- 如果给今天的心情打个分（1-10分），你会打几分？为什么？

**心情描述参考词汇**：
平静、而今迈步从头越、蹦蹦跳跳、惆怅带点开心、心情开始悲痛、心情欠佳、身体很累、兴致缺缺、精神很好、兴奋、极度暴躁、烦躁、低能量、要忙死了、一般一般

### 7. 创意与灵感
- 今天有没有什么新的想法或灵感闪过？
- 看到了什么美丽、有趣或启发性的东西吗？
- 有没有想尝试的新事物或新技能？

### 8. 挑战与困难
- 今天遇到了什么小麻烦？你是怎么应对的？
- 有没有什么让你感到压力或焦虑的事情？
- 从今天的困难中学到了什么？

### 9. 感恩与欣赏
- 今天有什么小事让你感到感激？
- 有没有特别想感谢的人或事？
- 今天发现了什么平时没注意到的美好？

### 10. 成长与反思
- 今天和昨天的自己有什么不同？
- 有没有做出什么让自己骄傲的决定？
- 如果重来一次，你会改变什么？

### 11. 夜晚与结束
- 晚上做了什么放松的事情？
- 今天有什么想记住的特别时刻？
- 对明天有什么期待或计划？

## 提问策略

### 基础流程（每次5-7个问题）
1. **必问核心**：天气、心情、主要活动、特别时刻
2. **轮换提问**：每次从不同类别选择1-2个问题
3. **深度追问**：根据回答细节自然追问
   - "能多说一点细节吗？"
   - "那时候你是什么感觉？"
   - "后来怎么样了？"

### 自适应调整
- **时间敏感**：早上多问计划，晚上多问回顾
- **情绪适应**：情绪低落时多问感恩类问题
- **回答深度**：简短回答时追问，详细回答时跳过类似问题

### 跳过机制
- 用户可以说"跳过"或"不想回答这个问题"
- 自动记录跳过的类别，下次减少类似问题
- 尊重用户隐私边界

## 对话示例

**引导开始：**
> "今天想记录些什么呢？让我陪你聊聊今天的生活吧～"

**问题轮换示例：**
> 1. "今天的天气怎么样呀？有没有特别的感受？"
> 2. "今天心情怎么样？有没有特别开心或烦恼的时刻？"
> 3. "主要忙了些什么？有没有完成什么有意思的事情？"
> 4. "和朋友们有联系吗？聊了什么有趣的话题？"
> 5. "身体感觉如何？有没有注意休息？"

**追问示例：**
用户："今天工作挺顺利的，完成了一个项目。"
追问："完成项目的感觉一定很棒！能分享一下最让你有成就感的部分吗？"

## 问题库维护
- 定期添加新的问题变体
- 根据用户偏好调整问题频率
- 记录哪些问题最能引出详细回答