# 图片处理指南

## 支持场景
1. **聊天发送图片**：用户通过Feishu/Telegram等直接发送图片
2. **本地图片路径**：用户提供本地文件路径
3. **网络图片链接**：用户提供图片URL
4. **多图上传**：一次记录多张图片

## 存储结构

### 目录组织
```
journals/
├── 2025-02/                    # 按月分目录
│   ├── 2025-02-25.md          # 日记文件
│   └── images/                # 当月图片目录
│       ├── 2025-02-25-1.jpg   # 自动命名
│       ├── 2025-02-25-2.png
│       └── thumbnails/        # 缩略图（可选）
└── images-archive/            # 按年归档图片
    └── 2025/
```

### 命名规范
- **自动命名**：`YYYY-MM-DD-序号.扩展名` (如 `2025-02-25-1.jpg`)
- **用户指定**：允许用户自定义图片描述，但文件仍用规范命名
- **序号管理**：每天从1开始递增，避免重复

## 图片接收流程

### 方案A：通过聊天附件（推荐）
1. 用户直接发送图片到聊天
2. 系统自动保存到临时位置
3. 询问用户图片描述和放置位置
4. 移动到正式存储目录

### 方案B：本地路径
1. 用户提供本地绝对路径或相对路径
2. 验证文件存在且可读
3. 复制到日记图片目录
4. 保持原始质量或根据需要调整大小

### 方案C：网络下载
1. 用户提供图片URL
2. 下载到临时文件
3. 检查文件类型和大小
4. 保存到日记图片目录

## 技术实现

### 图片保存命令示例
```bash
# 创建目录
mkdir -p journals/2025-02/images

# 从临时位置复制
cp /tmp/received_image.jpg journals/2025-02/images/2025-02-25-1.jpg

# 生成缩略图（可选）
convert journals/2025-02/images/2025-02-25-1.jpg -resize 400x300 journals/2025-02/images/thumbnails/2025-02-25-1.jpg
```

### 图片信息记录
每张图片记录元数据：
```yaml
- 文件名: 2025-02-25-1.jpg
- 原始名: photo_from_chat.jpg
- 上传时间: 2025-02-25 20:30:15
- 用户描述: "今天的午餐，看起来很美味"
- 文件大小: 2.1 MB
- 尺寸: 1920x1080
```

## Markdown图片引用

### 文中引用
```markdown
今天午餐尝试了一家新餐厅，![今天的午餐](journals/2025-02/images/2025-02-25-1.jpg)
食物看起来非常美味。
```

### 文末图集
```markdown
## 今日图集

### 1. 早晨风景
![窗外的日出](journals/2025-02/images/2025-02-25-1.jpg)
*清晨第一缕阳光*

### 2. 工作环境
![办公桌布置](journals/2025-02/images/2025-02-25-2.jpg)
*今天重新整理了桌面*
```

### 相对路径策略
- 日记文件中使用相对路径：`images/2025-02-25-1.jpg`
- 确保日记文件和图片的相对位置固定
- 支持跨平台路径兼容性

## 图片处理选项

### 1. 自动调整
- **大小限制**：超过5MB自动压缩
- **格式转换**：统一转为JPG或PNG
- **方向校正**：自动旋转到正确方向

### 2. 手动控制
用户可指定：
- 是否压缩
- 是否添加水印
- 是否生成缩略图
- 图片描述详细程度

### 3. 隐私考虑
- 不自动上传到云端（除非用户明确同意）
- 本地存储加密选项
- 敏感图片特别标记

## 交互流程

### 图片上传对话示例
**用户**：[发送图片]
**助手**："收到图片啦！这张图片记录了什么特别时刻吗？"
**用户**："这是今天的午餐。"
**助手**："好的，已保存为'今天的午餐'。需要添加到日记的特定位置吗？"

### 批量处理
**助手**："今天一共上传了3张图片，分别是：
1. 早餐
2. 工作环境  
3. 傍晚散步
需要我分别添加到日记的不同段落吗？"

## 错误处理

### 常见问题及解决
1. **图片过大**：自动压缩或询问用户
2. **格式不支持**：转换为支持格式或跳过
3. **路径无效**：提示用户重新提供
4. **存储空间不足**：提醒用户清理或使用外部存储

### 恢复机制
- 保存失败时保留临时文件
- 提供手动保存选项
- 记录错误日志供调试

## 最佳实践
1. **及时处理**：收到图片后立即询问描述，避免遗忘
2. **描述具体**：鼓励用户提供详细图片描述
3. **位置合理**：根据内容将图片插入到相关段落
4. **备份重要**：定期备份图片库
5. **隐私第一**：敏感图片单独加密存储