# 散文式日记格式指南

## 设计理念
- **连贯叙事**：将分散的回答编织成流畅的故事
- **保留原味**：保持用户的语言风格和表达习惯
- **时间逻辑**：按时间顺序或主题逻辑组织内容
- **情感融入**：自然地穿插感受和反思

## 散文结构模板

### 基本框架
```
# [日期] 星期几 · [天气/心情标签]

[开头段落：整体感受和一天概览]

[上午时光：早晨活动、工作/学习]

[午后时光：社交、午餐、下午活动]

[傍晚与夜晚：放松、家庭、个人时间]

[反思与感悟：学习、成长、感恩]

[结尾：明日期待或晚安问候]

---
**关键词**：[提取3-5个关键词]
**心情指数**：[1-10分]
**图片**：[图片描述或位置]
```

### 段落连接技巧
- **时间过渡**："清晨醒来时..." → "到了上午..." → "午后时光..." → "傍晚时分..." → "临睡前..."
- **情感过渡**："虽然...但是..." → "令人高兴的是..." → "有趣的是..."
- **主题过渡**："除了工作之外..." → "说到...不得不提..." → "另一方面..."

### 语言风格调整
- **亲切自然**：像朋友聊天，避免正式报告语气
- **细节丰富**：添加感官描述（看到的、听到的、闻到的、感觉到的）
- **适度修饰**：使用比喻、拟人等修辞，但不过度

## 生成算法

### 1. 信息提取
从用户回答中提取：
- **事实信息**：做了什么、见了谁、去了哪里
- **情感信息**：感受、情绪、态度
- **细节信息**：具体描述、对话片段、感官体验
- **反思信息**：学习、感悟、决定

### 2. 内容组织策略

#### 策略A：时间线叙事（推荐）
```
1. 早晨 → 上午 → 下午 → 晚上
2. 每个时段：活动 + 感受 + 细节
3. 自然过渡时间点
```

#### 策略B：主题聚焦
```
1. 主要事件（重点详写）
2. 人际互动
3. 个人成长
4. 生活琐事
```

#### 策略C：情感线索
```
1. 情绪起点
2. 情绪变化节点
3. 情绪高潮
4. 情绪平复
```

### 3. 散文生成步骤
1. **确定主线**：选择最突出的主题或时间线
2. **排列素材**：按逻辑顺序组织提取的信息
3. **添加过渡**：使用连接词和过渡句
4. **润色语言**：调整句式，丰富词汇
5. **检查连贯**：确保前后逻辑一致

## 示例对比

### 用户原始回答：
- "早上喝了咖啡，工作完成了报告"
- "中午和同事吃了火锅，聊得很开心"
- "晚上看了电影，有点感动"

### 生成散文：
```
清晨被咖啡的香气唤醒，一杯温热下肚，开始了新的一天。上午专注于工作报告的撰写，当最后一段文字落定时，心中涌起一阵小小的成就感。

午间与同事相约火锅店，红油翻滚间，笑声与故事也随之沸腾。大家分享着工作中的趣事和生活里的琐碎，那一刻，工作的疲惫似乎都消散在蒸腾的热气中。

夜幕降临时，选择了一部温暖的电影。荧幕上的故事轻轻触动心弦，那些关于爱与失去的主题，让人不禁沉思。临睡前，回忆这一天，虽平凡却充满了值得珍藏的片段。
```

## 个性化调整

### 根据用户风格：
- **简洁型用户**：保持语言精炼，避免过度修饰
- **细腻型用户**：添加更多感官细节和情感描写
- **幽默型用户**：加入轻松俏皮的语言

### 根据内容性质：
- **忙碌工作日**：侧重成就感和时间管理
- **放松周末**：侧重休闲体验和个人兴趣
- **特殊事件日**：以事件为中心展开叙述

## 图片整合

### 文字配合图片：
1. **描述性配合**："正如照片中记录的那样..."
2. **情感性配合**："这张图片让我回想起当时..."
3. **补充性配合**："虽然照片无法完全捕捉，但..."

### 图片位置标记：
- 文中引用：`![图片描述](images/YYYY-MM-DD/xxx.jpg)`
- 文末图集：集中展示所有图片并配简短说明

## 质量检查清单
- [ ] 时间逻辑是否合理？
- [ ] 情感表达是否自然？
- [ ] 细节是否充分但不冗长？
- [ ] 个人风格是否保留？
- [ ] 过渡是否流畅？
- [ ] 开头和结尾是否有呼应？

## 改进迭代
- 收集用户对生成日记的反馈
- 调整散文结构和语言风格
- 学习用户偏好的表达方式
- 不断优化生成算法