---
name: dianping-query
description: 查询大众点评餐厅信息。使用场景：(1) 用户要查询某家餐厅的评分、人均消费、地址 (2) 用户要搜索特定菜系或区域的餐厅推荐 (3) 用户要获取附近美食推荐。登录账号：一定S。重要：搜索时URL需包含城市ID（如hangzhou页面），账号定位北京时需使用URL参数方式绕过。
---

# Dianping Query

## Quick Start

1. 用 browser 工具打开大众点评**杭州首页**：https://www.dianping.com/hangzhou
   - 无需登录即可访问杭州地区内容
   - URL中的 `/hangzhou` 或 `cityId=3` 表示杭州
2. 确认登录状态（显示"一定S"即已登录）
3. 在搜索框输入餐厅名称或关键词
4. **重要**：搜索结果在**新标签页**打开，URL格式为 `https://www.dianping.com/ai-search?keyword=...`
5. 使用 `browser.tabs` 查看所有打开的页面
6. 从AI搜索结果页面提取餐厅信息卡片

## 登录账号

- 用户名：**一定S**
- 如果未登录，需要用户配合输入手机号和验证码

## 城市定位问题处理

### 问题现象
- 账号显示定位在北京，无法切换到杭州
- 搜索结果会跳转到北京地区

### 解决方案（按优先级）

**方案1：使用杭州URL（推荐）**
- 直接访问 `https://www.dianping.com/hangzhou` 而非首页
- 搜索结果会自动关联杭州地区
- 无需账号切换，cookie定位不影响URL访问

**方案2：搜索时指定城市**
- 搜索词加上城市名，如："杭州滨江区好吃的餐厅"
- URL参数会包含城市信息：`keyword/3/0_杭州滨江区...`

**方案3：浏览器地址栏修改**
- 在地址栏手动修改城市ID
- 北京是 cityId=2，杭州是 cityId=3

## 城市ID参考

| 城市 | cityId | URL示例 |
|:--|:--|:--|
| 杭州 | 3 | dianping.com/hangzhou |
| 北京 | 2 | dianping.com/ |
| 上海 | 1 | dianping.com/shanghai |

## 搜索结果提取

从AI搜索结果页面提取以下信息：
- 餐厅名称（link元素）
- 评分（⭐数字星）
- 人均消费（¥数字）
- 地址/位置
- 特色描述和推荐菜品
- 用户评价摘要

## 常见搜索场景

**按名称查询：**
```
搜索词：靠北泰式打抛饭
结果：店铺名称、评分4.2星、¥37、地址在拱墅区银树湾
```

**按区域查询（使用杭州URL）：**
```
URL: https://www.dianping.com/hangzhou
搜索词：滨江区好吃的餐厅
结果：7,799个相关商户，包含TOP推荐列表
```

**按菜系查询：**
```
搜索词：杭州泰式料理
结果：多家泰式餐厅列表，包含评分、人均、地址
```

## 注意事项

- 搜索结果页面可能需要滚动加载完整内容
- 店休、营业时间等特殊信息也会显示在结果中
- 点击餐厅名称可查看详情页
- 使用杭州URL可以绕过账号定位问题
