---
name: diankeyuan-contacts
description: 管理电科院人员信息和科室关系的技能。支持添加、查询、更新电科院工作人员、科室、办公室等信息。
metadata:
  {
    "openclaw":
      {
        "emoji": "⚡",
        "version": "1.0.0",
        "author": "灵儿",
        "category": "工作效率"
      }
  }
---

# 电科院联系人管理技能

管理电科院（电力科学研究院）的人员信息、科室关系、办公室位置等。

---

## 📋 功能列表

### 1. 添加人员
```
添加电科院人员：[姓名] [科室] [职务] [办公室] [备注]
```

### 2. 查询人员
```
查询 [姓名] 的信息
电科院有哪些人？
[科室] 有哪些人？
```

### 3. 查询科室
```
电科院有哪些科室？
[科室] 的办公室在哪？
```

### 4. 更新信息
```
更新 [姓名] 的 [职务/办公室] 为 [新值]
```

### 5. 删除人员
```
删除 [姓名] 的信息
```

---

## 💾 数据存储

数据保存在：`/Users/aibin/.openclaw/workspace/diankeyuan_contacts.json`

### 数据结构
```json
{
  "departments": {
    "系统所": {
      "二次评估室": {
        "office": "1512",
        "members": [
          {
            "name": "叶新",
            "role": "市场",
            "office": "1512",
            "addedAt": "2026-03-02"
          }
        ]
      }
    }
  }
}
```

---

## 🔧 使用示例

### 添加人员
```
添加电科院人员：叶新 系统所 - 二次评估室 市场 1512
添加电科院人员：王云凤 系统所 - 二次评估室 工程师 1512
```

### 查询人员
```
查询叶新的信息
→ 叶新，系统所 - 二次评估室，市场，办公室 1512

系统所有哪些人？
→ 叶新（市场）、王云凤（工程师）

二次评估室的办公室在哪？
→ 1512 室
```

### 更新信息
```
更新叶新的职务为 市场经理
→ 已更新：叶新 职务 市场 → 市场经理
```

### 删除人员
```
删除叶新的信息
→ 已删除：叶新 的信息
```

---

## 📊 快速命令

| 命令 | 说明 |
|------|------|
| `电科院人员列表` | 显示所有人员 |
| `电科院科室列表` | 显示所有科室 |
| `查询 [姓名]` | 查询指定人员 |
| `添加 [姓名] [科室] [职务] [办公室]` | 添加人员 |
| `更新 [姓名] [字段] [新值]` | 更新信息 |
| `删除 [姓名]` | 删除人员 |

---

## 🎯 使用场景

- ✅ 记录电科院测试时遇到的人员
- ✅ 快速查询某个人在哪个科室
- ✅ 查找某个科室的办公室位置
- ✅ 维护电科院联系人网络
- ✅ 测试前快速了解相关人员

---

## 📝 注意事项

1. 所有操作会自动保存到 JSON 文件
2. 支持模糊查询（输入部分姓名即可）
3. 科室格式：`所 - 室`（如：系统所 - 二次评估室）
4. 办公室格式：房间号（如：1512）

---

*Version: 1.0.0 | Author: 灵儿 | Created: 2026-03-02*
