---
name: dhmz-weather
description: Get Croatian weather data, forecasts, and alerts from DHMZ (meteo.hr) - no API key required.
homepage: https://meteo.hr/proizvodi.php?section=podaci&param=xml_korisnici
metadata: { "openclaw": { "emoji": "🇭🇷", "requires": { "bins": ["curl"] } } }
---

# DHMZ Weather (Croatia)

Croatian Meteorological and Hydrological Service (DHMZ) provides free XML APIs. All data in Croatian, no authentication needed.

## Default Behavior

When this skill is invoked:
1. **If a city is provided as argument** (e.g., `/dhmz-weather Zagreb`): Immediately fetch and display weather for that city
2. **If no city is provided**: Infer the city from conversation context (user's location, previously mentioned cities, or project context). If no context available, default to **Zagreb** (capital city)

**Do not ask the user what they want** - just fetch the weather data immediately and present it in a readable format.

## Weather Emojis

Use these emojis when displaying weather data to make it more intuitive:

### Conditions
| Croatian | English | Emoji |
|----------|---------|-------|
| vedro, sunčano | clear, sunny | ☀️ |
| djelomično oblačno | partly cloudy | ⛅ |
| pretežno oblačno | mostly cloudy | 🌥️ |
| potpuno oblačno | overcast | ☁️ |
| slaba kiša | light rain | 🌦️ |
| kiša | rain | 🌧️ |
| jaka kiša | heavy rain | 🌧️🌧️ |
| grmljavina | thunderstorm | ⛈️ |
| snijeg | snow | 🌨️ |
| susnježica | sleet | 🌨️🌧️ |
| magla | fog | 🌫️ |
| rosa | dew | 💧 |

### Metrics
| Metric | Emoji |
|--------|-------|
| Temperature | 🌡️ |
| Humidity | 💧 |
| Pressure | 📊 |
| Wind | 💨 |
| Rain/Precipitation | 🌧️ |
| UV Index | ☀️ |
| Sea temperature | 🌊 |

### Wind Strength
| Description | Emoji |
|-------------|-------|
| calm, light | 🍃 |
| moderate | 💨 |
| strong/windy (vjetrovito) | 💨💨 |
| stormy (olujni) | 🌬️ |

### Alerts
| Level | Emoji |
|-------|-------|
| Green (no warning) | 🟢 |
| Yellow | 🟡 |
| Orange | 🟠 |
| Red | 🔴 |

## Current Weather

All Croatian stations (alphabetical):

```bash
curl -s "https://vrijeme.hr/hrvatska_n.xml"
```

By regions:

```bash
curl -s "https://vrijeme.hr/hrvatska1_n.xml"
```

European cities:

```bash
curl -s "https://vrijeme.hr/europa_n.xml"
```

## Temperature Extremes

Max temperatures:

```bash
curl -s "https://vrijeme.hr/tx.xml"
```

Min temperatures:

```bash
curl -s "https://vrijeme.hr/tn.xml"
```

Min at 5cm (ground frost):

```bash
curl -s "https://vrijeme.hr/t5.xml"
```

## Sea & Water

Adriatic sea temperature:

```bash
curl -s "https://vrijeme.hr/more_n.xml"
```

River temperatures:

```bash
curl -s "https://vrijeme.hr/temp_vode.xml"
```

## Precipitation & Snow

Precipitation data:

```bash
curl -s "https://vrijeme.hr/oborina.xml"
```

Snow height:

```bash
curl -s "https://vrijeme.hr/snijeg_n.xml"
```

## Forecasts

Today's forecast:

```bash
curl -s "https://prognoza.hr/prognoza_danas.xml"
```

Tomorrow's forecast:

```bash
curl -s "https://prognoza.hr/prognoza_sutra.xml"
```

3-day outlook:

```bash
curl -s "https://prognoza.hr/prognoza_izgledi.xml"
```

Regional forecasts:

```bash
curl -s "https://prognoza.hr/regije_danas.xml"
```

3-day meteograms (detailed):

```bash
curl -s "https://prognoza.hr/tri/3d_graf_i_simboli.xml"
```

7-day meteograms:

```bash
curl -s "https://prognoza.hr/sedam/hrvatska/7d_meteogrami.xml"
```

## Weather Alerts (CAP format)

Today's warnings:

```bash
curl -s "https://meteo.hr/upozorenja/cap_hr_today.xml"
```

Tomorrow's warnings:

```bash
curl -s "https://meteo.hr/upozorenja/cap_hr_tomorrow.xml"
```

Day after tomorrow:

```bash
curl -s "https://meteo.hr/upozorenja/cap_hr_day_after_tomorrow.xml"
```

## Specialized Data

UV index:

```bash
curl -s "https://vrijeme.hr/uvi.xml"
```

Forest fire risk index:

```bash
curl -s "https://vrijeme.hr/indeks.xml"
```

Biometeorological forecast (health):

```bash
curl -s "https://prognoza.hr/bio_novo.xml"
```

Heat wave alerts:

```bash
curl -s "https://prognoza.hr/toplinskival_5.xml"
```

Cold wave alerts:

```bash
curl -s "https://prognoza.hr/hladnival.xml"
```

## Maritime / Adriatic

Nautical forecast:

```bash
curl -s "https://prognoza.hr/jadran_h.xml"
```

Maritime forecast (sailors):

```bash
curl -s "https://prognoza.hr/pomorci.xml"
```

## Agriculture

Agro bulletin:

```bash
curl -s "https://klima.hr/agro_bilten.xml"
```

Soil temperature:

```bash
curl -s "https://vrijeme.hr/agro_temp.xml"
```

7-day agricultural data:

```bash
curl -s "https://klima.hr/agro7.xml"
```

## Hydrology

Hydro bulletin:

```bash
curl -s "https://hidro.hr/hidro_bilten.xml"
```

## Tips

- All responses are XML format
- Data is in Croatian language
- Station names use Croatian characters (UTF-8)
- Updates vary: current data ~hourly, forecasts ~daily
- For parsing, use `xmllint` or pipe to a JSON converter

Extract specific station with xmllint:

```bash
curl -s "https://vrijeme.hr/hrvatska_n.xml" | xmllint --xpath "//Grad[GradIme='Zagreb']" -
```

Convert to JSON (requires `xq` from yq package):

```bash
curl -s "https://vrijeme.hr/hrvatska_n.xml" | xq .
```

## Common Station Names

Zagreb, Split, Rijeka, Osijek, Zadar, Pula, Dubrovnik, Slavonski Brod, Karlovac, Varazdin, Sisak, Bjelovar, Cakovec, Gospic, Knin, Makarska, Sibenik

## Data Source

Official DHMZ (Drzavni hidrometeoroloski zavod) - Croatian Meteorological and Hydrological Service: <https://meteo.hr>
