# DHMZ Weather Skill for Claude Code

A Claude Code skill for fetching Croatian weather data from DHMZ (Croatian Meteorological and Hydrological Service). No API key required.

## Features

- Current weather for 50+ Croatian stations
- 3-day and 7-day forecasts
- Adriatic sea temperatures
- Weather alerts (CAP format)
- Temperature extremes (min/max)
- Precipitation and snow data
- Maritime/nautical forecasts
- UV index, forest fire risk
- Agricultural and hydrological data

## Installation

Copy the `SKILL.md` file to your Claude Code skills directory:

```bash
# Create skills directory if it doesn't exist
mkdir -p ~/.claude/skills/dhmz-weather

# Copy the skill file
cp SKILL.md ~/.claude/skills/dhmz-weather/
```

## Usage

In Claude Code, use the slash command:

```
/dhmz-weather Zagreb
/dhmz-weather Split 3 dana
/dhmz-weather temperatura mora
```

### Examples

| Command | Description |
|---------|-------------|
| `/dhmz-weather` | Current weather for Zagreb (default) |
| `/dhmz-weather Zadar` | Current weather for Zadar |
| `/dhmz-weather Split 3 dana` | 3-day forecast for Split |
| `/dhmz-weather temperatura mora` | Adriatic sea temperatures |

## Supported Cities

Zagreb, Split, Rijeka, Osijek, Zadar, Pula, Dubrovnik, Slavonski Brod, Karlovac, Varazdin, Sisak, Bjelovar, Cakovec, Gospic, Knin, Makarska, Sibenik, and 30+ more stations.

## Requirements

- `curl` (for fetching XML data from DHMZ APIs)

## Data Source

All weather data is provided by [DHMZ](https://meteo.hr) (Drzavni hidrometeoroloski zavod) - the official Croatian Meteorological and Hydrological Service.

## License

MIT
