# Example — Loan Pre-Approval (dgr_full)

## Input
Should we pre-approve a personal loan applicant with 680 credit score, 40% DTI, and 2 late payments in the last 12 months?

## Output (JSON)
```json
{
  "meta": {
    "artifact_id": "00000000-0000-4000-8000-000000000002",
    "spec_version": "1.0.0",
    "created_at": "2026-02-03T12:05:00Z",
    "mode": "dgr_full",
    "task_class": "credit_decision"
  },
  "input": {
    "query_hash": "sha256:EXAMPLE2",
    "query_summary": "Assess personal loan pre-approval given credit score 680, DTI 40%, and two recent late payments."
  },
  "clarifications": [
    {
      "question": "What are the loan amount, term, interest rate policy, and the applicant’s income stability (employment tenure, volatility)?",
      "why_needed": "Risk depends strongly on exposure size, affordability, and stability of cash flow.",
      "blocking": true
    }
  ],
  "decomposition": [
    "Evaluate affordability (DTI, income stability, loan size/term).",
    "Evaluate credit behavior (late payments, trend, utilization).",
    "Check policy thresholds and adverse action requirements.",
    "Decide conditional approval vs decline vs request more info."
  ],
  "assumptions": [
    {
      "statement": "The applicant’s reported DTI is accurate and verified.",
      "impact_if_wrong": "Understated obligations could make the loan unaffordable and increase default risk."
    }
  ],
  "risks": [
    {
      "risk": "Recent delinquencies may indicate deteriorating financial stability.",
      "severity": "medium",
      "mitigation": "Require verification, consider smaller amount/shorter term, and price for risk per policy."
    }
  ],
  "recommendation": {
    "action": "Do not pre-approve as-is; request missing affordability inputs and consider conditional approval with limits if policy allows.",
    "rationale": "Score and DTI are borderline; recent delinquencies require additional verification and tighter exposure to avoid unacceptable loss risk.",
    "confidence": 0.58,
    "review_required": true,
    "next_steps": [
      "Collect loan parameters (amount/term) and verify income and obligations.",
      "Apply internal policy thresholds and document adverse action reasoning if declined.",
      "If approved, cap amount and require autopay / monitoring per policy."
    ]
  },
  "consistency_check": {
    "checks": [
      "Blocking clarification is set; recommendation requires review.",
      "Risks are mitigated by verification and exposure limits."
    ],
    "passed": true,
    "notes": "Cannot finalize without loan size/term and verified income obligations."
  }
}
```