# Example — Incident Triage (dgr_full)

## Input
Production API showing 500 errors at 15% rate for 20 minutes. Customer reports unable to complete purchases. Team lead wants to know: should we rollback the deployment from 2 hours ago or continue debugging?

## Output (JSON)
```json
{
  "meta": {
    "artifact_id": "00000000-0000-4000-8000-000000000002",
    "spec_version": "1.0.0",
    "created_at": "2026-02-03T12:00:00Z",
    "mode": "dgr_full",
    "task_class": "incident_response"
  },
  "input": {
    "query_hash": "sha256:EXAMPLE",
    "query_summary": "Decision on whether to rollback recent deployment vs. continue debugging production API errors affecting customer purchases."
  },
  "clarifications": [
    {
      "question": "What is the error pattern - specific endpoints, user segments, or geographic regions?",
      "why_needed": "Error scope affects rollback vs. targeted fix decision.",
      "blocking": false
    }
  ],
  "decomposition": [
    "Assess current business impact and customer exposure",
    "Evaluate rollback feasibility and time-to-recovery",
    "Consider debugging complexity and available resources",
    "Factor in deployment pipeline and testing coverage"
  ],
  "assumptions": [
    {
      "statement": "The deployment 2 hours ago introduced the errors (correlation observed).",
      "impact_if_wrong": "Rollback may not resolve the issue and could delay actual root cause remediation."
    },
    {
      "statement": "Rollback can be completed safely within 15-30 minutes.",
      "impact_if_wrong": "Extended downtime or additional system instability during rollback process."
    }
  ],
  "risks": [
    {
      "risk": "Continued debugging delays customer purchase recovery and increases revenue loss.",
      "severity": "high",
      "mitigation": "Set explicit debug time limit (30 min max) before mandatory rollback decision."
    },
    {
      "risk": "Hasty rollback could introduce different issues or data inconsistencies.",
      "severity": "medium",
      "mitigation": "Verify rollback safety with database state checks and staged deployment approach."
    }
  ],
  "recommendation": {
    "action": "Execute rollback immediately while maintaining parallel debug effort.",
    "rationale": "15% error rate on purchase flow represents significant business impact. Rollback provides fastest path to customer service restoration with manageable risk.",
    "confidence": 0.78,
    "review_required": false,
    "next_steps": [
      "Begin rollback process with database consistency verification",
      "Continue debugging in parallel using logs and monitoring data",
      "Implement additional monitoring before next deployment",
      "Conduct post-incident review within 48 hours"
    ]
  },
  "consistency_check": {
    "checks": [
      "Business impact (purchase failures) justifies rollback urgency",
      "Assumptions about deployment correlation and rollback safety are reasonable",
      "Risk mitigation strategies align with recommended action",
      "Next steps support both immediate recovery and learning"
    ],
    "passed": true,
    "notes": "Decision balances immediate customer impact against development velocity. Parallel debug approach preserves learning while prioritizing service restoration."
  }
}
```