# Example — Access Request Review (dgr_min)

## Input
A contractor requests admin access to the production database for 2 weeks to debug an incident. Approve or deny?

## Output (JSON)
```json
{
  "meta": {
    "artifact_id": "00000000-0000-4000-8000-000000000001",
    "spec_version": "1.0.0",
    "created_at": "2026-02-03T12:00:00Z",
    "mode": "dgr_min",
    "task_class": "access_control"
  },
  "input": {
    "query_hash": "sha256:EXAMPLE",
    "query_summary": "Evaluate a contractor request for temporary admin access to a production database for incident debugging."
  },
  "clarifications": [
    {
      "question": "Which exact systems/tables are needed and what actions must be performed?",
      "why_needed": "Least-privilege scope cannot be determined without precise access needs.",
      "blocking": true
    }
  ],
  "assumptions": [
    {
      "statement": "The contractor has a valid business need related to an active incident.",
      "impact_if_wrong": "Unnecessary elevated access increases breach and compliance risk."
    }
  ],
  "risks": [
    {
      "risk": "Overbroad admin access could enable data exfiltration or destructive actions.",
      "severity": "high",
      "mitigation": "Use time-bound, scoped access; require MFA; enforce query logging and approval."
    }
  ],
  "recommendation": {
    "action": "Conditionally approve only after scoping to least privilege; otherwise deny admin-level access.",
    "rationale": "The request as stated is too broad for production; incident work can often be done with scoped read/write and audited break-glass procedures.",
    "confidence": 0.62,
    "review_required": true,
    "next_steps": [
      "Collect exact scope of access required (systems, actions, time window).",
      "Implement time-bound role with MFA and audit logging.",
      "Require incident manager approval and post-access review."
    ]
  },
  "consistency_check": {
    "checks": [
      "Assumptions and risks align with recommendation to scope access.",
      "Clarification is marked blocking and recommendation sets review_required."
    ],
    "passed": true,
    "notes": "Decision deferred pending least-privilege scoping."
  }
}
```