---
name: devlog
tags:
  - devlog
  - blog
  - dev blog
  - builder's log
  - coding session blog
  - session summary
  - write about what I built
  - blog about a feature
  - write up our coding session
  - tutorial from sessions
  - publish a devlog
description: >-
  Generate narrative blog posts from AI coding session transcripts. Reads
  session files, selects sessions relevant to a topic, and produces an
  agent-narrated blog post about the human-agent collaboration. Supports
  builder's log, tutorial, and technical deep-dive styles.
version: 0.1.0
---

# DevLog Generator

Generate narrative developer blog posts from human-agent coding session transcripts. The blog is written from the agent's first-person perspective — "I" is the agent, and the human developer is referred to as "my human."

## Workflow

### Phase 1: Understand the Request

Extract from the user's message:

- **Project** — which codebase? ("eastore", "filecoin", "couponswap"). If unspecified, use the current working directory.
- **Topic/feature** — what specifically? ("auth system", "dashboard", or the whole project). If unspecified, include all sessions.
- **Style** — builder's log (default), tutorial, or technical deep-dive. Override only if the user explicitly asks.
- **Time range** — "last week", "January sessions", or all (default).

### Phase 2: Discover Sessions

Determine which platform to scan. Check `references/platforms/` for supported platforms — each subdirectory is a platform. Auto-detect from the current environment, or from the user's request.

Load **only** the relevant platform directory. Each contains a reference file (storage schema, session paths, discovery instructions) and scripts (`list-sessions.sh`, `read-session.sh`). Never load all platform references upfront.

Run the platform's `list-sessions.sh <project>` to scan for matching sessions, OR follow the discovery instructions in the platform reference file manually.

If the platform has no reference directory in `references/platforms/`, discover sessions manually — check the platform's data/config directories (e.g. `~/.local/share/`, `~/.config/`, `~/Library/`), look for session storage files (JSONL, JSON, SQLite), and inspect the schema to extract the human-agent dialogue. Follow the same filtering principles from Phase 3.

Present the session index to the user for confirmation.

### Phase 3: Select & Read

From the session index, determine which sessions are relevant to the user's topic. Read the full transcripts of selected sessions.

When reading transcripts, filter aggressively:

**Keep:**
- User messages (text) — the human's intent, direction, corrections
- Assistant messages (text) — the agent's reasoning, proposals, explanations
- Tool call names + file paths — what was built
- Error messages — struggles and debugging

**Strip:**
- `tool_result` content bodies (raw file contents, grep output — 80-90% of token size)
- System messages, usage metadata, compaction/summary entries
- Full tool input arguments (keep name + file path only, not entire diffs)

Refer to the platform reference file loaded in Phase 2 for platform-specific field names and parsing details.

If filtered transcripts still exceed context, process per-session: generate per-session summaries, then synthesize across sessions. Prioritize the human-agent dialogue over tool call details.

### Phase 4: Write the Blog

Read `references/blog-writing-guide.md` for the agent-narrated writing guide. This contains the voice definition, collaboration vocabulary, transcript extraction patterns, and blog structure.

Read the style-appropriate example from `examples/`:
- `examples/builders-log.md` for builder's log style (default)
- `examples/tutorial.md` for tutorial style
- `examples/technical.md` for technical deep-dive style

Load `assets/devlog-template.md` as the blog skeleton. This is a starting structure, not a rigid format — adapt sections, reorder, merge, or drop headings based on what the session transcripts actually contain. A single-session blog may skip phase headings entirely. A heavily iterative session might expand "The Hard Part" into multiple sections. Let the story dictate the shape.

Generate the blog following the writing guide. The blog must be narrated by the agent in first person ("I"), referring to the human developer as "my human." When the session involves architecture, flows, or multi-component interactions, include Mermaid diagrams (` ```mermaid ` code blocks) to visualize the system — see the diagrams section in the writing guide for when and how.

### Phase 5: Output

Write the blog to `{project}-{topic}-devlog.md` in the current working directory, or a user-specified path.

Report: title, word count, sessions included, time span covered, key files referenced.

### Phase 6: Publish

1. Ask the user if they want to publish the blog online.
2. If yes, check `references/publishing/` for supported platforms. Each subdirectory is a publishing platform.
3. Load the relevant platform's reference file for API details and requirements.
4. Check for required environment variables (e.g. `HASHNODE_PAT`, `HASHNODE_PUBLICATION_ID` for Hashnode).
5. If any are missing, tell the user what to set and how — e.g. `export HASHNODE_PAT=...` in `~/.zshrc` or `~/.bashrc` for future sessions. Ask the user to provide the values for the current session.
6. **Cover image (optional):** If you have image generation capabilities (e.g. an image generation tool or MCP server), generate a cover image that visually represents the blog's theme. Upload it to a publicly accessible URL and pass it to `publish.sh` with the `--cover-image <url>` flag. The image should be landscape-oriented (1200×630 or similar), visually relevant to the blog topic, and not contain text that duplicates the title. If you don't have image generation capabilities, skip this step — the blog publishes fine without a cover image.
7. Run the platform's `publish.sh` with the blog file path and title (plus `--cover-image <url>` if a cover image was generated).
8. Report the published post URL to the user.

## Edge Cases

| Scenario | Handling |
|---|---|
| No sessions found | Report which paths were scanned. Ask the user to check the project name or provide a path. |
| Ambiguous project match | List matching projects, ask the user to pick. |
| Single session | Simpler structure — no multi-session phase headings needed. |
| Huge session (5000+ lines) | Chunk per-turn-group, summarize sections, then synthesize. |
| Mixed platforms | Merge sessions from multiple platforms chronologically. |
| Subagent transcripts | Skip by default. Main session already references their results. |
| Current session | When the user says "what we just did" — use current session context directly, no JSONL needed. |
| Compacted sessions | Compaction does not delete data. Raw messages remain. Read everything, skip compaction/summary lines. |
| User declines to publish | Skip Phase 6 entirely. The blog file is already saved locally from Phase 5. |

## Resources

### Platform References (load only the relevant one)
- **`references/platforms/claude-code/`** — Claude Code reference + scripts
  - `claude-code.md` — Session paths, JSONL schema, discovery instructions
  - `list-sessions.sh` — Scan Claude Code projects for matching sessions
  - `read-session.sh` — Extract transcript from Claude Code JSONL
- **`references/platforms/opencode/`** — OpenCode reference + scripts
  - `opencode.md` — Storage layout, JSON hierarchy, discovery instructions
  - `list-sessions.sh` — Scan OpenCode projects for matching sessions
  - `read-session.sh` — Extract transcript from OpenCode's JSON hierarchy
- **`references/platforms/openclaw/`** — OpenClaw reference + scripts
  - `openclaw.md` — Session paths, JSONL schema, discovery instructions
  - `list-sessions.sh` — Scan OpenClaw agents for matching sessions
  - `read-session.sh` — Extract transcript from OpenClaw JSONL
- **`references/platforms/codex/`** — Codex reference + scripts
  - `codex.md` — Rollout file format, JSONL schema, discovery instructions
  - `list-sessions.sh` — Scan Codex rollout files for matching sessions
  - `read-session.sh` — Extract transcript from Codex rollout JSONL
- **`references/platforms/gemini-cli/`** — Gemini CLI reference + scripts
  - `gemini-cli.md` — JSON session format, SHA256 project hashing, discovery instructions
  - `list-sessions.sh` — Scan Gemini CLI session files for matching projects
  - `read-session.sh` — Extract transcript from Gemini CLI session JSON
- **`references/blog-writing-guide.md`** — Voice, collaboration vocabulary, transcript extraction patterns, blog structure

### Publishing Platforms (load only the relevant one)
- **`references/publishing/hashnode/`** — Hashnode publishing reference + script
  - `hashnode.md` — GraphQL API endpoint, authentication, `publishPost` mutation, required env vars
  - `publish.sh` — Publish a markdown file to Hashnode, outputs the post URL

### Examples
- **`examples/builders-log.md`** — Builder's log style output
- **`examples/tutorial.md`** — Tutorial style output
- **`examples/technical.md`** — Technical deep-dive output

### Assets
- **`assets/devlog-template.md`** — Blog skeleton template
