---
name: desktop-pet
description: "Give OpenClaw a body — a tiny fluid glass ball desktop pet with voice cloning, 15+ eye expressions, desktop lyrics overlay, and 7 mood colors. Electron-based, pure CSS/JS animation."
homepage: https://github.com/kk43994/claw-desktop-pet
metadata: {"clawdbot":{"emoji":"🦞","requires":{"bins":["node","npm"],"env":[]}}}
---

# 🦞 Claw Desktop Pet — Give OpenClaw a Body

A desktop AI companion that gives your OpenClaw agent a physical presence on your desktop.

## What is it?

A 67px fluid glass ball that lives on your desktop — it breathes, blinks, speaks, and reacts. Messages appear like floating desktop lyrics with white glow text. Your agent isn't invisible anymore.

## Features

- 🫧 **Fluid Glass Ball** — 67px sphere with 7 mood color systems
- 👀 **15+ Eye Expressions** — blink, curious, sleepy, surprised, follow mouse
- 🎵 **Desktop Lyrics** — typewriter text, white glow, mouse pass-through
- 🎤 **Voice Cloning** — MiniMax Speech with 7 emotions, auto detection
- 🎨 **Dual Window Architecture** — sprite + lyrics, fully transparent
- ⚫ **Offline/Online Animation** — gray sleep → colorful revival with particles
- 💬 **Feishu/Lark Sync** — bidirectional message sync
- 🛡️ **Enterprise Stability** — auto-restart, error handling, performance monitoring

## Quick Start

```bash
# Clone the project
git clone https://github.com/kk43994/claw-desktop-pet.git
cd claw-desktop-pet

# Install dependencies
npm install

# Start (basic mode)
npm start

# Full AI mode — requires OpenClaw gateway running
openclaw gateway start
npm start
```

## Voice Setup (Optional)

### MiniMax Speech (Recommended — voice cloning + emotions)
Set your MiniMax API key in `pet-config.json`:
```json
{
  "minimax": {
    "apiKey": "your-api-key",
    "voiceId": "your-cloned-voice-id"
  }
}
```

### Fallback: Edge TTS (Free, no setup)
Works out of the box — uses Microsoft Edge TTS as fallback.

## Architecture

```
┌── Sprite Window (200×220) ──┐  ┌── Lyrics Window (400×100) ──┐
│  67px fluid glass ball       │  │  Desktop lyrics overlay      │
│  15+ eye expressions         │  │  Typewriter + white glow     │
│  SVG icon toolbar            │  │  Mouse pass-through          │
│  7 mood color systems        │  │  Auto-fade after voice done  │
└──────────────────────────────┘  └──────────────────────────────┘
```

## Tech Stack

- **Electron** — Desktop framework (dual transparent windows)
- **OpenClaw** — AI dialogue engine
- **MiniMax Speech** — Voice cloning + emotion TTS
- **Pure CSS/JS** — All animations, no sprite sheets

## Design Philosophy

- **Air-feel UI** — Like desktop lyrics, doesn't interfere with work
- **iOS minimalism** — Simple, elegant, icon-only buttons
- **Lobster identity** — Expressed through red-orange fluid color, not literal appendages
- **References** — Nomi robot, AIBI robot, Bunny Hole

## Links

- 🔗 GitHub: https://github.com/kk43994/claw-desktop-pet
- 📖 Full documentation in README
- 📄 MIT License

---

Made with ❤️ and 🦞 by zhouk (kk43994)
