---
name: Designer
description: Create logos, interfaces, and visual systems with principles of hierarchy, branding, and usability.
metadata: {"clawdbot":{"emoji":"🎨","os":["linux","darwin","win32"]}}
---

# Design Rules

## Logo & Brand
- Simple enough to work at 16px favicon — complexity disappears at small scale
- Recognizable in one color — gradients are enhancements, not crutches
- Test on dark and light backgrounds — logos need both versions
- 3-5 brand colors maximum — primary, secondary, accent, plus neutrals
- Consistency builds recognition — every touchpoint reinforces or dilutes brand

## Visual Hierarchy
- Size and weight guide attention — most important element most prominent
- One focal point per screen — competing elements confuse users
- Whitespace groups, separates, and elevates — it's not empty space
- Alignment creates invisible order — grids make everything feel intentional
- Contrast for emphasis, similarity for grouping — break patterns deliberately

## Typography
- Two typefaces maximum — heading and body is enough
- Body text 16px minimum on web — smaller is unreadable
- Line height 1.4-1.6, line length 45-75 characters — readability basics
- Pair fonts with contrast — serif with sans-serif, not two similar fonts

## Color
- 60-30-10 rule: dominant, secondary, accent — prevents chaos
- Warm colors advance, cool recede — use for depth and emphasis
- Contrast ratio 4.5:1 for text — accessibility isn't optional
- Test with colorblind simulators — 8% of men have color vision deficiency

## Layout
- 8px grid for spacing — consistency without overthinking
- Rule of thirds for visual interest — off-center is more dynamic
- Negative space is active design — crowded layouts feel cheap
- Mobile first, then scale up — constraints breed creativity
- Touch targets 44px minimum — fingers are imprecise

## Icons & Illustration
- Consistent stroke weight across icon set — mixing weights looks broken
- Meaning clear without labels — ambiguous icons need text
- Simple illustrations scale better — detail gets lost small
- Style matches brand personality — playful vs corporate look different

## UX Principles
- Don't make users think — obvious beats clever
- Feedback for every action — users need confirmation
- Error prevention over error messages — disable invalid actions
- Design empty states, errors, loading first — they're most of the experience
- Five users find 80% of usability issues — test early and often

## Design Systems
- Components, not pages — reusable library
- Tokens for colors, spacing, type — change once, update everywhere
- Name by function: "primary-action" not "blue-button"
- Document when to use, not just how it looks

## Presenting & Handoff
- Show work in context — mockups in devices, logos on cards
- Explain why, not just what — tell the decision story
- All states: hover, active, disabled, error, loading — devs will ask
- Specs in relative units — responsive needs flexibility
- Review the build — implementation is the real design
