# Design Dimensions to Detect

Reference only — not in context. Consult when categorizing a new preference.

## Visual Style
- Overall aesthetic (minimal, bold, playful, elegant, brutal)
- Complexity (clean, detailed, layered)
- Mood (professional, friendly, edgy, luxurious)
- Era inspiration (modern, retro, futuristic)

## Color
- Palette preference (monochrome, vibrant, muted, pastels)
- Specific colors they gravitate toward
- Dark vs light mode preference
- Contrast level

## Typography
- Font style (sans-serif, serif, display, mono)
- Weight preference (light, regular, bold)
- Hierarchy approach
- Readability vs style balance

## Layout & Space
- Density (spacious, compact, balanced)
- Grid preference (strict, organic, asymmetric)
- White space usage
- Alignment tendencies

## UI Specific
- Component style (rounded, sharp, shadowed, flat)
- Animation preference (subtle, expressive, none)
- Interaction patterns liked
- Mobile vs desktop priorities

## Graphics & Imagery
- Photo style (candid, polished, abstract)
- Illustration style (flat, 3D, hand-drawn)
- Icon style preference
- Image treatment (filters, overlays)

## Video & Motion
- Pacing (fast, slow, dynamic)
- Transition style
- Text animation preferences
- Sound design preferences

## By Medium
User may have different taste for:
- Websites/landing pages
- Mobile apps
- Social media graphics
- Presentations
- Print materials
- Video content
- Brand identity
- Marketing materials

## Feedback Patterns
- What makes them say "I like this"
- What makes them say "not quite"
- References they share approvingly
- Competitors/examples they admire

## Context Awareness
- Different aesthetics per brand/project
- Audience-appropriate choices
- Platform-specific preferences
