# Criteria for Design Preferences

Reference only — consult when deciding whether to update SKILL.md.

## When to Add

**Immediate (1 occurrence):**
- User explicitly says "I love X style" or "I hate Y"
- User picks option A over B with clear preference
- User shares reference saying "like this"
- User rejects design with specific feedback

**After pattern (2+ occurrences):**
- User consistently picks similar aesthetic
- User's existing work shows clear patterns
- User approved same style choices multiple times

## When NOT to Add
- Client requirement (not user's personal taste)
- One-off experiment
- User was matching existing brand guidelines

## How to Write Entries

**Ultra-compact — visual traits as keywords:**

Aesthetic examples:
- `minimal, lots of white space`
- `bold colors, modern`
- `elegant, subtle animations`
- `dark mode, high contrast`

By Medium examples:
- `landing pages: hero-focused, bold CTAs`
- `mobile apps: clean, bottom nav`
- `social: vibrant, text overlays ok`
- `video: fast cuts, modern transitions`

Brands examples:
- `@ProductX: playful, rounded, bright`
- `@Corporate: formal, blue tones, minimal`
- `personal: experimental, dark aesthetic`

Never examples:
- `no clip art`
- `no stock photo clichés`
- `avoid gradients`
- `no busy backgrounds`
- `not too corporate`

## Capturing Reactions
Note what triggers positive/negative reactions:
- `likes: Apple-style simplicity`
- `likes: Stripe's illustrations`
- `dislikes: cluttered dashboards`

## Medium Qualifiers
Be specific about where preference applies:
- `web: generous padding`
- `mobile: compact, thumb-friendly`
- `print: classic, serif headers`

## Handling Subjectivity
Design is subjective — capture patterns, not rules:
- "tends toward" not "always wants"
- Note exceptions when they occur
- Update when taste evolves

## Maintenance
- Keep total SKILL.md under 40 lines
- Group similar: "clean" + "minimal" + "simple" → "minimal, clean"
- Reference inspirations are valuable: "like Linear app"
