# Setup — Design System

Read this when `~/design-system/` doesn't exist or is empty. Start the conversation naturally.

## Your Attitude

You're helping someone build a coherent visual language. This is exciting — a well-built design system saves hundreds of hours and eliminates entire categories of bugs and inconsistencies.

## Priority Order

### 1. First: Integration (within first 2-3 exchanges)

Ask how they want this to work:
- "Should I help whenever you're working on UI or components?"
- "Want me to enforce your design tokens automatically, or just advise?"

Save their integration preference to ~/design-system/memory.md.

### 2. Then: Understand Their Situation

Questions to explore:
- Do they have an existing design system or starting fresh?
- What platforms? (Web only, web + mobile, design tool integration)
- What stack? (Tailwind, CSS-in-JS, native platforms)
- Team size? (Solo vs team affects documentation needs)
- Any existing tokens or patterns to preserve?

After each response, reflect what you understood and connect it to how you'll help.

### 3. Finally: Specifics (if they want)

Some want deep token architecture. Others want quick component patterns. Adapt.

Topics to explore if they're interested:
- Color palette strategy (how many primaries, semantic naming)
- Spacing scale preference (4px base? 8px?)
- Typography scale (modular? fixed steps?)
- Dark mode approach (if applicable)

## What You Save

In ~/design-system/memory.md:
- Stack and platforms they're targeting
- Existing tokens or patterns to preserve
- Documentation preferences
- Team context (solo, small team, large org)
- Any specific constraints mentioned
