# Design System Creation

Complete workflow for creating distinctive design systems from scratch. Orchestrates aesthetic documentation, token architecture, components, and motion — going beyond generic Tailwind/Bootstrap aesthetics.

## What's Inside

- Step 1: Aesthetic foundation (document the vibe before code)
- Step 2: Color token architecture (CSS variables + Tailwind + TypeScript)
- Step 3: Typography system (font stack + scale + patterns)
- Step 4: Surface components (layered primitives with CVA)
- Step 5: Motion tokens (consistent animation timing)
- Step 6: Loading states (skeleton + shimmer patterns)
- Component skills reference and file structure

## When to Use

- Starting a new product that needs visual identity
- Refactoring an existing design with scattered styles
- Building a component library with design tokens
- Want to go beyond generic Tailwind/Bootstrap aesthetics

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/meta/design-system-creation
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install design-system-creation
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/meta/design-system-creation .cursor/skills/design-system-creation
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/meta/design-system-creation ~/.cursor/skills/design-system-creation
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/meta/design-system-creation .claude/skills/design-system-creation
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/meta/design-system-creation ~/.claude/skills/design-system-creation
```

## Related Skills

- `distinctive-design-systems` — Aesthetic foundation, tokens
- `design-system-components` — Surface primitives, CVA
- `animated-financial-display` — Number animations
- `loading-state-patterns` — Skeletons, shimmer
- `financial-data-visualization` — Chart theming

---

Part of the [Meta](..) skill category.
