import os
import sys
import time

# Set API credentials for Zhipu
if not os.environ.get("OPENAI_API_KEY"): print("Warning: OPENAI_API_KEY not set");
os.environ["OPENAI_BASE_URL"] = "https://open.bigmodel.cn/api/coding/paas/v4"

# Monkey-patch langchain to add delays
from langchain_openai import ChatOpenAI

_original_invoke = ChatOpenAI.invoke
_original_stream = ChatOpenAI.stream

def _patched_invoke(self, *args, **kwargs):
    time.sleep(2)
    return _original_invoke(self, *args, **kwargs)

def _patched_stream(self, *args, **kwargs):
    time.sleep(2)
    return _original_stream(self, *args, **kwargs)

ChatOpenAI.invoke = _patched_invoke
ChatOpenAI.stream = _patched_stream
print("Applied 2s rate limit delay")

from denario import Denario
from denario.llm import LLM

# GLM models for different agents
glm47 = LLM(name="glm-4.7", max_output_tokens=16384, temperature=0.7)
glm46 = LLM(name="glm-4.6", max_output_tokens=16384, temperature=0.5)

print("\n=== Loading existing Denario project ===")
d = Denario(project_dir="./denario_output", clear_project_dir=False)

print("\n=== Generating Results with GLM-4.7/4.6 ===")
print("(This may take several minutes - uses multi-agent system...)")
d.get_results(
    engineer_model=glm47,
    researcher_model=glm46,
    planner_model=glm47,
    plan_reviewer_model=glm46,
    orchestration_model=glm47,
    formatter_model=glm46,
    max_n_attempts=5,
    max_n_steps=4
)

print("\n\n=== Generated Results ===")
d.show_results()
