import os
import sys
import time

# Add TinyTeX to PATH
os.environ["PATH"] = f"{os.environ['HOME']}/Library/TinyTeX/bin/universal-darwin:" + os.environ["PATH"]

# Set API credentials for Zhipu
if not os.environ.get("OPENAI_API_KEY"): print("Warning: OPENAI_API_KEY not set");
os.environ["OPENAI_BASE_URL"] = "https://open.bigmodel.cn/api/coding/paas/v4"

# Monkey-patch langchain to add delays
from langchain_openai import ChatOpenAI

_original_invoke = ChatOpenAI.invoke
_original_stream = ChatOpenAI.stream

def _patched_invoke(self, *args, **kwargs):
    time.sleep(2)
    return _original_invoke(self, *args, **kwargs)

def _patched_stream(self, *args, **kwargs):
    time.sleep(2)
    return _original_stream(self, *args, **kwargs)

ChatOpenAI.invoke = _patched_invoke
ChatOpenAI.stream = _patched_stream
print("Applied 2s rate limit delay")

from denario import Denario
from denario.llm import LLM

# GLM-4.7 for paper generation
glm = LLM(name="glm-4.7", max_output_tokens=16384, temperature=0.7)

print("\n=== Loading existing Denario project ===")
d = Denario(project_dir="./denario_output", clear_project_dir=False)

# Set mock results
mock_results = """
## Experimental Results

### Dataset: 50,000 inference runs across 12 configurations

### DATCER Performance
| Metric | Value |
|--------|-------|
| Model Size MAE | 2.3B |
| Quantization Acc | 87.4% |
| Optimality Gap | 8.2% |

### Improvements vs Baseline
- Latency: -34%
- Throughput: +28%  
- Cost: -41%

DATCER achieved near-oracle performance on 91.8% of test cases.
"""
d.set_results(mock_results)

print("\n=== Generating NeurIPS Paper with GLM-4.7 ===")
print("(This will take several minutes...)")
d.get_paper(llm=glm, journal="NeurIPS")

print("\n=== Paper generation complete! ===")
print("Check ~/denario_test/denario_output/paper_output/ for LaTeX files")
