import os
import sys
import time

# Set API credentials for Zhipu
if not os.environ.get("OPENAI_API_KEY"): print("Warning: OPENAI_API_KEY not set");
os.environ["OPENAI_BASE_URL"] = "https://open.bigmodel.cn/api/coding/paas/v4"

# Monkey-patch langchain to add delays
from langchain_openai import ChatOpenAI

_original_invoke = ChatOpenAI.invoke
_original_stream = ChatOpenAI.stream

def _patched_invoke(self, *args, **kwargs):
    time.sleep(2)
    return _original_invoke(self, *args, **kwargs)

def _patched_stream(self, *args, **kwargs):
    time.sleep(2)
    return _original_stream(self, *args, **kwargs)

ChatOpenAI.invoke = _patched_invoke
ChatOpenAI.stream = _patched_stream
print("Applied 2s rate limit delay")

from denario import Denario
from denario.llm import LLM

# Use GLM-4.7 this time for methodology
glm = LLM(name="glm-4.7", max_output_tokens=16384, temperature=0.7)

print("\n=== Loading existing Denario project ===")
d = Denario(project_dir="./denario_output", clear_project_dir=False)

print("\n=== Generating Methodology with GLM-4.7 ===")
print("(This will take several minutes...)")
d.get_method(mode="fast", llm=glm)

print("\n\n=== Generated Methodology ===")
d.show_method()
