import os
import sys
import time

# Set API credentials for Zhipu
if not os.environ.get("OPENAI_API_KEY"): print("Warning: OPENAI_API_KEY not set");
os.environ["OPENAI_BASE_URL"] = "https://open.bigmodel.cn/api/coding/paas/v4"

# Monkey-patch langchain to add delays
from langchain_openai import ChatOpenAI

_original_invoke = ChatOpenAI.invoke
_original_stream = ChatOpenAI.stream

def _patched_invoke(self, *args, **kwargs):
    time.sleep(2)  # Rate limit delay
    return _original_invoke(self, *args, **kwargs)

def _patched_stream(self, *args, **kwargs):
    time.sleep(2)  # Rate limit delay
    return _original_stream(self, *args, **kwargs)

ChatOpenAI.invoke = _patched_invoke
ChatOpenAI.stream = _patched_stream
print("Applied 2s rate limit delay to LLM calls")

from denario import Denario
from denario.llm import LLM

# Create GLM model definition
glm = LLM(name="glm-4.5-air", max_output_tokens=8192, temperature=0.7)

# Initialize project
print("\n=== Initializing Denario ===")
d = Denario(project_dir="./denario_output", clear_project_dir=True)

# Set data description
data_description = """
## Dataset: Multi-Agent AI System Performance Metrics

Performance metrics from distributed multi-agent AI on heterogeneous hardware.

### Variables:
- response_latency_ms: Time to first token
- tokens_per_second: Generation throughput  
- model_size_b: Model size (billions)
- hardware_type: GPU (3090, A100, H100)
- quantization: fp16, int8, int4

### Research Question:
Predict optimal model routing based on task complexity and hardware.

### Sample: 50,000 runs, 12 configurations
"""

print("=== Setting Data Description ===")
d.set_data_description(data_description)

print("\n=== Generating Research Idea with GLM-4.5-air ===")
print("(This will take a few minutes due to rate limiting...)")
d.get_idea(mode="fast", llm=glm)

print("\n\n=== Generated Idea ===")
d.show_idea()
