import os
import sys
import time

# Add TinyTeX to PATH
os.environ["PATH"] = f"{os.environ['HOME']}/Library/TinyTeX/bin/universal-darwin:" + os.environ["PATH"]

# Set API credentials
if not os.environ.get("OPENAI_API_KEY"): print("Warning: OPENAI_API_KEY not set");
os.environ["OPENAI_BASE_URL"] = "https://open.bigmodel.cn/api/coding/paas/v4"
os.environ["PERPLEXITY_API_KEY"] = "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"

# Monkey-patch for rate limits
from langchain_openai import ChatOpenAI
_original_invoke = ChatOpenAI.invoke
_original_stream = ChatOpenAI.stream
def _patched_invoke(self, *args, **kwargs):
    time.sleep(2)
    return _original_invoke(self, *args, **kwargs)
def _patched_stream(self, *args, **kwargs):
    time.sleep(2)
    return _original_stream(self, *args, **kwargs)
ChatOpenAI.invoke = _patched_invoke
ChatOpenAI.stream = _patched_stream

from denario import Denario
from denario.llm import LLM

glm = LLM(name="glm-4.7", max_output_tokens=16384, temperature=0.7)

print("=== Loading Denario project ===")
d = Denario(project_dir="./denario_output", clear_project_dir=False)

print("\n=== Regenerating paper WITH citations ===")
d.get_paper(llm=glm, journal="NeurIPS", add_citations=True)

print("\n=== Done! Check paper_v3_citations.pdf ===")
