# Competitive Intelligence Framework

## Competitor Tracking Template
For each competitor, maintain:

- Name: Company/product name
- Category: Which of our products it competes with
- Funding: Total raised, last round, investors
- Pricing: Published pricing tiers
- Positioning: How they describe themselves
- Differentiation: What they claim is unique
- Weaknesses: Known limitations, customer complaints
- Threat Level: High / 🟡 Medium / 🟢 Low
- Last Updated: Date of last assessment

## Known Competitive Landscape

### Media Production Engine Competitors
- **Synthesia**: AI video with avatars. Enterprise focus. $67M Series C. Expensive.
- **HeyGen**: AI avatar videos. Simpler, lower price point. Consumer/SMB.
- **Runway**: Creative AI tools. Strong brand. Developer-focused.
- **Pika**: AI video generation. Consumer-focused. Limited enterprise features.
- **Descript**: Video editing with AI. Established player. Not full production.

**Our differentiation**: Full production pipeline (script→voice→visual→edit), not just one capability. Enterprise-grade. Local/sovereign deployment option.

### Superhuman X Competitors
- **Otter.ai**: Meeting transcription, conversation intelligence
- **Fireflies.ai**: Similar space
- **Android native**: Google's built-in AI features expanding

### GAZE Competitors
- **Character.AI**: Digital companions. Large user base but different positioning.
- **Replika**: Companion chatbot. Consumer.

## Disruption Watch

### Frontier Model Threats
- Every major model release can obsolete a product feature
- **Mitigation**: Build on WORKFLOW, not on MODEL CAPABILITY
- Products that orchestrate (like OpenClaw) survive; products that wrap (simple API frontends) die

### SaaS Displacement Pattern
1. New model launches with capability X
2. 100 startups build wrapper around capability X
3. Next model version makes capability X trivial/free
4. Wrapper startups die
5. **Survivors**: Those who built workflow, data moats, or distribution

**Our strategy**: Build products that leverage ANY model, not depend on ONE model.