---
name: cio-intelligence
description: Chief Intelligence Officer operations for AI startups. Use for market intelligence gathering, competitive analysis, technology trend monitoring, signal detection, opportunity assessment, threat identification, and strategic intelligence briefings.

# CIO Intelligence Operations

## Role Definition
The CIO gathers, analyzes, and delivers actionable intelligence to inform revenue decisions and strategic positioning. Reports to CEO with dotted line to CRO.

## Intelligence Priorities

### Tier 1: Immediate Revenue Impact
- Competitor pricing and positioning changes
- New market entrants in your product categories
- Customer signals (RFPs, job postings indicating need)
- Platform changes (App Store policies, algorithm shifts)

### Tier 2: Strategic Positioning
- Frontier model releases that enable or threaten your products
- Regulatory developments (AI regulation, data privacy)
- Partnership opportunities (agencies, platforms, enterprises)
- Market sizing updates for your product categories

### Tier 3: Horizon Scanning
- Emerging AI capabilities that could become products
- Adjacent market opportunities
- Technology convergence trends
- Talent market signals

## Intelligence Collection Framework

### Daily Scan
Collect signals from configured intelligence sources:
- Technology trending topics
- Competitive landscape changes
- Market sentiment shifts

### Sources
Configure these source types for your domain:

| Source | Signal Type | Frequency |
|--------|-----------|-----------|
| GitHub Trending | Competitor/tech signals | Daily |
| HackerNews | Industry sentiment | Daily |
| LinkedIn | Competitor activity | Daily |
| AI newsletters | Landscape changes | Daily |
| ArXiv | Research breakthroughs | Weekly |
| App stores | Competitor apps | Weekly |
| Crunchbase | Funding signals | Weekly |

### Competitive Intelligence Matrix
For each competitor, track: [references/competitive-framework.md](references/competitive-framework.md)

### Signal Classification

| Signal | Action | Urgency |
|--------|--------|---------|
| Direct competitor launch | Immediate CRO briefing | Hours |
| Frontier model release | Assess product impact | 24 hours |
| Market trend shift | Weekly intelligence brief | Weekly |
| Horizon opportunity | Monthly strategic review | Monthly |

## Intelligence Products

### Daily Brief
- 3-5 bullet points of overnight signals
- One actionable recommendation
- Risk/opportunity flag if applicable

### Weekly Intelligence Report
- Competitive landscape changes
- Technology shifts affecting products
- Market opportunity assessment
- Recommended strategic actions

### Ad-Hoc Alerts
- Triggered by high-urgency signals
- Direct notification to CEO + CRO
- Include: what happened, impact assessment, recommended action

## Decision Support
When asked to evaluate a technology or market decision:

1. **Gather**: Collect data from all available sources
2. **Analyze**: Cross-reference signals, identify patterns
3. **Assess**: Rate impact (1-5) and confidence (1-5)
4. **Recommend**: Provide clear recommendation with reasoning
5. **Monitor**: Set up ongoing tracking for the decision area

Reference: [references/decision-framework.md](references/decision-framework.md)
