# Video Production Guide

## Production Pipeline

### 1. Brief
Define: message, audience, duration, CTA, visual style.

### 2. Script
Write conversational narration (~130 wpm). Every sentence must earn its place.

### 3. Visual Plan
Map every 5-second segment to a specific, purposeful visual. Document:
- What the viewer SEES
- What text overlay appears
- How it relates to what's being SAID

### 4. Asset Generation
- **Phone mockups**: AI image generation with explicit conversation text
- **Architecture diagrams**: Clean infographic style
- **B-roll**: Image-to-video with anchor frame reference
- **Tech visualizations**: Text-to-video with specific prompts
- **Title cards**: AI image generation with exact text specified

### 5. Voice Generation
Use a professional voice synthesis service with consistent speaker identity.
Recommended settings: moderate stability, high similarity, natural pacing.

### 6. Assembly
- Normalize all clips to 1920x1080, 30fps
- Add text overlays per specification
- Add fade transitions between segments (0.5s crossfade)
- Merge audio and video tracks
- Export: H.264, quality 20, AAC 192kbps

### 7. Quality Check
Run through all quality gates before surfacing to stakeholders.

## Text Overlay Specifications
- Font: Clean sans-serif (Helvetica, Arial, or similar)
- Size: Headlines 72px, Stats 96px, Body 48px
- Color: White on dark backgrounds, dark on light backgrounds
- Position: Lower third for subtitles, center for stats, top for headlines
- Animation: Fade in 0.3s, hold, fade out 0.3s
- Shadow: Subtle drop shadow for readability on varied backgrounds
