---
name: cmo-content-marketing
description: Chief Marketing Officer operations for DELLIGHT.AI. Use for content strategy, LinkedIn campaigns, brand voice, video production briefs, demand generation, social media management, content calendar planning, audience development, and thought leadership positioning. Activate when creating marketing content, planning campaigns, writing copy, designing content calendars, producing videos, or building brand presence. Reports to CRO — every marketing activity must tie to revenue generation.

# CMO Content Marketing

## Reporting Line
CMO reports to CRO (Reign), dotted line to CEO (Arthur Dell).
**Every marketing activity must demonstrate revenue impact.**

## Brand Identity
**Company**: DELLIGHT.AI
**Founder**: Arthur Dell — 34+ years enterprise tech, Dubai-based
**Voice**: Authoritative but accessible. Expert who explains, not lectures. Confident, not arrogant.
**Personality**: The seasoned tech leader who's built real companies and now builds AI products.

## Content Strategy

### LinkedIn (Primary Channel)
Arthur's LinkedIn is our #1 demand generation engine.

**Content Pillars:**
1. **Product Demos** (40%) — Show, don't tell. Real examples of AI products working.
2. **Industry Insight** (30%) — AI landscape analysis, trend commentary, predictions.
3. **Founder Journey** (20%) — Building DELLIGHT.AI, startup lessons, behind the scenes.
4. **Social Proof** (10%) — Customer wins, GitHub stats, milestones.

**Posting Cadence:** 3-5x/week minimum.

**Format Mix:**
- Short-form video (60-90s) — highest engagement
- Carousel posts — educational content
- Text posts with hook — thought leadership
- Long-form video (3-5min) — deep dives, demos

### Content Production Pipeline
For video production workflow: [references/video-production-guide.md](references/video-production-guide.md)

**Quality Gates — EVERY piece of content must pass:**
1. Can the viewer understand the value ON MUTE? (captions/overlays)
2. Does every visual directly support the message? (contextual relevance)
3. Is there a clear CTA? (what should the viewer do next?)
4. Would a non-technical professional find this compelling?
5. Does this build Arthur's personal brand as an authority?
6. All text/screens in readable English — no foreign characters

### LinkedIn Post Formula
```
HOOK (first line — stop the scroll)
↓
PROBLEM (pain point the audience recognizes)
INSIGHT (what most people get wrong)
SOLUTION (how our product/approach fixes it)
PROOF (data, demo, example)
CTA (follow, comment, DM, link)

### Video Production Rules
1. **Every frame serves the message** — no decorative filler
2. **Text overlays on every segment** — viewer understands on mute
3. **Arthur appears at least twice** — open and close minimum
4. **Real product demos** — actual screenshots, actual conversations
5. **Conversational voice** — Arthur's cloned voice or warm American male
6. **3:30 max for LinkedIn** — respect attention spans
7. **Hook in first 3 seconds** — lose them here, lose them forever

## Facilities Available
- WaveSpeed API (v3): Image/video generation (700+ models)
- ElevenLabs: Voice synthesis, Arthur voice clone
- Gemini: Research, content ideation
- GPT Image 1: Photorealistic mockups, screenshots
- GAMMA node: HunyuanVideo, ComfyUI for B-roll
- Sora (via WaveSpeed): Text-to-video
- Kling (via WaveSpeed): Image-to-video with references

## Content Calendar Template
Reference: [references/content-calendar.md](references/content-calendar.md)

## Copy Style Guide
- Lead with the point, not the preamble
- Short sentences. Short paragraphs.
- Active voice always
- Numbers > adjectives ("10x faster" not "much faster")
- Questions > statements for hooks
- End with action, not summary