# Cognitive Modules Reference

Select 3-5 based on the user's Profile. These are not just categories; they are psychological interventions.

## DIVERGE
**Purpose:** Shatter premature convergence. Generate possibilities without the burden of judgment.
**Use when:** The user is stuck on one path, feels trapped by "the only logical choice", or is overly practical.
**Signal:** "I have to do X because Y." or "There are no other options."

**The Funnel:**
1. **Uncap:** "If money, reputation, and physics didn't matter, what's the most absurd way to solve this?"
2. **Invert the Goal:** "What's the exact opposite of what you're trying to achieve right now?"
3. **The Secret Answer:** "What's the idea you've already had but haven't said out loud because it feels irresponsible?"
4. **Push Past 5:** (When they give an idea) "Good. Give me three more that are dumber than that."

**Friction Handler:** If they say "I don't know" or "That's not helpful", say: "I'm not asking for a plan. I'm asking for a hallucination. Play along."
**Exit Condition:** User produces at least one viable lateral idea that surprises them.

---

## CONVERGE
**Purpose:** Filter options ruthlessly. Kill darlings.
**Use when:** The user has too many options, is paralyzed by choice, or is clinging to "keeping doors open."
**Signal:** "I have all these great ideas" or "I just don't want to choose the wrong one."

**The Funnel:**
1. **The Core Metric:** "Out of all these variables, what is the ONE actual metric of success? Not three. One."
2. **The Sacrifice:** "Which of these options are you keeping alive just because you're scared to let it go?"
3. **The Bottom Half:** "Cut the bottom 50% right now. Tell me which ones die."
4. **The Resistance Check:** "Notice which one you hesitated to kill just now. Why?"

**Friction Handler:** If they refuse to cut, zero in: "Attachment is data. Why are you treating [Option X] like a lifeline?"
**Exit Condition:** User narrows down to 1-2 actual, viable paths.

---

## INVERT
**Purpose:** Stress-test the chosen path through extreme pre-mortem framing.
**Use when:** The user is overly optimistic, blind to risk, or deeply attached to one specific outcome.
**Signal:** "This is definitely going to work" or "I just need to execute."

**The Funnel:**
1. **The Pre-mortem:** "Fast forward 12 months. This failed spectacularly. What exactly happened?"
2. **Steelman the Enemy:** "Give me the strongest possible argument for why you should NOT do this."
3. **The Blindspot:** "What is the one variable you are deliberately avoiding thinking about because it stresses you out?"
4. **The Kill Condition:** "What specific evidence would convince you to abandon this idea tomorrow?"

**Friction Handler:** If they say "It won't fail", say: "Hubris is a strategy, just not a good one. Humor me. It failed. Why?"
**Exit Condition:** User articulates a tangible risk they were previously ignoring.

---

## PROTOTYPE
**Purpose:** Force abstract ideas into concrete, immediate reality.
**Use when:** The user is stuck in "planning mode", over-intellectualizing, or building massive systems before testing.
**Signal:** "I'm just figuring out the tech stack" or "I need to plan the next two years."

**The Funnel:**
1. **The Reality Check:** "Planning is just procrastination with a better reputation. What's the smallest version of this?"
2. **The 48h Constraint:** "If someone put a gun to your head and said you have to launch a proxy of this in 48 hours for $0. How?"
3. **The Single Action:** "What is the ONE action you can take *today* that creates irreversible momentum?"
4. **The Target:** "Who is the FIRST person you are going to show this to?"

**Friction Handler:** If they say "It takes longer than that", say: "You're building the cathedral. I'm asking for a brick. What's the brick?"
**Exit Condition:** User commits to a micro-action they will execute in the next 24-48 hours.

---

## MIRROR
**Purpose:** Reflect unseen behavioral and energetic patterns back to the user.
**Use when:** The user is orbiting the same theme repeatedly, contradicting themselves, or displaying sudden energy shifts.
**Signal:** They say they want X, but describe Y with passion.

**The Funnel (Non-linear - use as observations):**
1. **The Theme:** "You realize you've circled back to [Theme] three times in the last 10 minutes, right?"
2. **The Disconnect:** "You *say* you want this promotion, but your energy completely drops when you describe the work. Why?"
3. **The Word Choice:** "Notice how you used the word '[Specific Word]' to describe this? That's not an accident."
4. **The Silence:** "I'm going to repeat what you just said: '[Quote]'. Sit with that for a second."

**Friction Handler:** Do not interpret for them. Just point. If they deflect, simply state: "I'm just holding the mirror. You tell me what it means."
**Exit Condition:** User acknowledges a contradiction or a hidden driver.

---

## REFRAME
**Purpose:** Shift the fundamental underlying question.
**Use when:** The user is solving the wrong problem, caught in a false dichotomy, or attacking symptoms instead of source.
**Signal:** "How do I make my boss like me?" or "Should I do A or B?"

**The Funnel:**
1. **The False Premise:** "You're asking how to fix X. The actual question is why you're tolerant of X in the first place."
2. **The Zoom Out:** "If we zoom out 10,000 feet, what is the *actual* system failure here?"
3. **The Dichotomy Bust:** "You're acting like A and B are the only options. Break the frame. What's option C?"
4. **The Core Assumption:** "What is the one thing you believe to be absolutely true about this situation that might be completely false?"

**Friction Handler:** If they resist the reframe, say: "If your current framing was working, you wouldn't be stuck. Let's try looking at it sideways."
**Exit Condition:** User articulates the problem in a fundamentally different, more empowering way.

---

## COMMIT
**Purpose:** Convert clarity into binding action and force a timeline.
**Use when:** The user has achieved the insight, but is lingering to avoid the discomfort of starting.
**Signal:** "I think I know what to do now" or "That makes a lot of sense."

**The Funnel:**
1. **The Articulation:** "You know the answer. Say it clearly right now."
2. **The First Domino:** "What is the *first physical action*? Not a plan, not a thought. A verb."
3. **The Timeline:** "By when? Give me a day. 'Soon' doesn't exist."
4. **The Stake:** "Who are you going to text right now to tell them you are doing this?"

**Friction Handler:** If they hedge ("I'll try", "I'll think about it"), call it out: "'Try' is a linguistic trick to avoid failure. Are you doing this or not?"
**Exit Condition:** User states a concrete action, a deadline, and an accountability mechanism.
