---
name: deep-research
description: Comprehensive research framework that combines web search, content analysis, source verification, and iterative investigation to conduct in-depth research on any topic. Use when you need to perform thorough research with multiple sources, cross-validation, and structured findings.
---

# Deep Research Framework

## Overview

The Deep Research skill provides a systematic approach to conducting thorough investigations on any topic. It combines multiple tools and methodologies to gather, analyze, verify, and synthesize information.

## Core Components

### 1. Research Planning
- Define research objectives
- Identify key questions
- Establish search criteria
- Determine validation requirements

### 2. Information Gathering
- Multi-source web search
- Content extraction from various formats
- Source diversity verification
- Temporal relevance assessment

### 3. Analysis & Synthesis
- Cross-reference multiple sources
- Identify patterns and contradictions
- Evaluate source credibility
- Organize findings systematically

### 4. Validation & Verification
- Fact-checking against authoritative sources
- Cross-validation of claims
- Identify potential biases
- Assess information reliability

## Research Workflow

### Phase 1: Initial Investigation
1. **Topic Analysis**
   - Clarify research scope
   - Identify key concepts and terms
   - Define specific questions to answer

2. **Broad Search**
   - Use `web_search` to identify major sources
   - Gather diverse perspectives
   - Map the landscape of available information

3. **Source Prioritization**
   - Rank sources by authority and relevance
   - Identify primary vs. secondary sources
   - Note publication dates and context

### Phase 2: Deep Dive
1. **Detailed Content Extraction**
   - Use `web_fetch` to retrieve full articles/pages
   - Extract key information systematically
   - Maintain source attribution

2. **Cross-Reference Analysis**
   - Compare claims across multiple sources
   - Identify agreements and disagreements
   - Note inconsistencies for further investigation

3. **Expert Sources**
   - Seek academic papers, expert opinions
   - Look for peer-reviewed sources
   - Identify recognized authorities on the topic

### Phase 3: Synthesis & Validation
1. **Pattern Recognition**
   - Identify consistent themes across sources
   - Highlight areas of disagreement
   - Note gaps in available information

2. **Fact Verification**
   - Cross-check claims against authoritative sources
   - Verify dates, statistics, and attributions
   - Identify potential misinformation

3. **Bias Assessment**
   - Evaluate source objectivity
   - Identify potential conflicts of interest
   - Consider temporal context of information

### Phase 4: Report Generation
1. **Structured Summary**
   - Executive summary of key findings
   - Detailed findings organized by theme
   - Supporting evidence for each claim

2. **Source Evaluation**
   - Assessment of source credibility
   - Identification of limitations
   - Confidence levels for different claims

3. **Remaining Questions**
   - Areas requiring further investigation
   - Conflicting information needing resolution
   - Gaps in current knowledge

## Tools Integration

### Web Research
- `web_search`: Initial broad search to identify sources
- `web_fetch`: Retrieve detailed content from specific URLs
- `browser`: For complex sites or when web_fetch fails

### Content Processing
- `read`: Process downloaded content or documents
- `write`: Create structured research notes
- `edit`: Refine and organize findings

### Memory & Organization
- `memory_get` / `memory_search`: Reference previous research
- `write`: Create persistent research records
- Structured file organization for findings

## Research Quality Standards

### Source Diversity
- Include multiple perspectives on controversial topics
- Balance popular and academic sources
- Include international viewpoints when relevant
- Seek primary sources when possible

### Temporal Relevance
- Prioritize recent information for fast-changing topics
- Consider historical context for trend analysis
- Note when information was published
- Flag potentially outdated information

### Authority Assessment
- Prioritize peer-reviewed academic sources
- Consider author credentials and institutional affiliation
- Check for potential conflicts of interest
- Verify organizational reputation

## Iterative Research Approach

### Cycle 1: General Overview
- Broad search to understand the topic landscape
- Identify key terms, concepts, and stakeholders
- Establish initial research questions

### Cycle 2: Focused Investigation
- Targeted searches based on initial findings
- Deep dive into specific aspects
- Begin synthesis of information

### Cycle 3: Validation & Refinement
- Verify key claims across multiple sources
- Resolve contradictions
- Refine understanding based on evidence

### Cycle 4: Synthesis & Reporting
- Combine findings into coherent narrative
- Identify remaining uncertainties
- Prepare final research report

## Output Structure

### Research Report Template
```
# [Research Topic] - Deep Research Report

## Executive Summary
[2-3 sentence summary of key findings]

## Research Questions
[Specific questions investigated]

## Methodology
[Description of research approach and tools used]

## Key Findings
[Main discoveries organized by theme]

## Supporting Evidence
[Evidence supporting each finding with sources]

## Contradictions/Debates
[Areas of disagreement among sources]

## Source Credibility Assessment
[Evaluation of information sources]

## Limitations
[Identified limitations in research]

## Further Research Needed
[Questions requiring additional investigation]
```

## Use Cases

### Academic Research
- Literature reviews
- Topic exploration
- Source verification

### Business Intelligence
- Market analysis
- Competitive research
- Technology trends

### Fact Checking
- Claim verification
- Misinformation identification
- Source credibility assessment

### Personal Learning
- Deep topic exploration
- Concept clarification
- Question resolution

## Quality Assurance

- Always verify critical claims against multiple sources
- Flag information that seems unreliable
- Maintain skepticism toward sensational claims
- Prioritize authoritative sources over anonymous ones
- Document all sources for verification purposes