# Deep Research Skill

A comprehensive research framework that combines web search, content analysis, source verification, and iterative investigation to conduct in-depth research on any topic.

## Purpose

This skill provides a systematic approach to conducting thorough investigations without relying on any specific AI model. Instead, it orchestrates various OpenClaw tools to gather, analyze, verify, and synthesize information.

## Components

- `SKILL.md`: Main skill definition with research methodology
- `research_template.md`: Template for structured research reports
- `research_workflow.js`: JavaScript implementation of the research workflow
- `README.md`: This file

## Usage

To conduct deep research using this skill, follow these patterns:

### Basic Research Task
```
Research Topic: [Specify the topic you want to investigate]
Research Questions: [List specific questions to answer]
```

### Research Process
1. **Planning**: Define research scope and questions
2. **Gathering**: Collect information from multiple sources
3. **Analysis**: Cross-reference and validate findings
4. **Synthesis**: Combine findings into coherent conclusions
5. **Reporting**: Generate structured research report

## Tool Integration

This skill leverages the following OpenClaw tools:
- `web_search` - For initial topic exploration
- `web_fetch` - For detailed content extraction
- `browser` - For complex web interactions
- `memory_search` - To reference previous research
- `write`/`edit` - To create and refine research reports

## Quality Standards

The research follows these quality standards:
- Source diversity verification
- Cross-validation of claims
- Credibility assessment
- Bias recognition
- Temporal relevance consideration

## Output Format

Research results follow a structured format:
- Executive summary
- Detailed findings
- Source evaluation
- Confidence levels
- Remaining questions for further research

## Integration with Models

While this skill operates independently of any specific AI model, it can work with any model (Qwen, Gemini, etc.) to assist with:
- Content analysis
- Pattern recognition
- Synthesis of findings
- Report generation