---
name: deepbook-cli
description: Operate the deepbook CLI for DeepBook reads (REST/SSE), global ~/.deepbook config/account management, on-chain spot trading, top-level swap execution, balance-manager ops, and margin trading.
---

# DeepBook CLI Skill

Use this skill when the user wants to use `deepbook` end to end: market data, wallet/config setup, and on-chain execution (spot, swap, manager, margin).

# Installation

Check if `deepbook` is installed:

```bash
deepbook --version
```

If not, install it:

```bash
npm install -g deepbook-cli
```

## Setup

1. Work from the `deepbook-cli` project directory.
2. Ensure `~/.deepbook/config.json` exists (auto-created on first run).
3. Configure global defaults in `~/.deepbook` (works from any path).
4. Optional one-off overrides can still be provided via global flags.

`mainnet`/`testnet` are aliases used consistently for both provider-side reads/streams and on-chain RPC.

## Global flags

- `--json`
- `--provider <name>`
- `--base-url <url>`
- `--stream-base-url <url>`
- `--network <mainnet|testnet>`
- `--rpc-url <url>`
- `--private-key <suiprivkey>`
- `--address <address>`
- `--manager <id>`
- `--trade-cap <id>`

## Available commands

- Top-level:
  - `deepbook providers`
  - `deepbook pools`
  - `deepbook orderbook <pool>` (alias: `deepbook book <pool>`)
  - `deepbook trades <pool>`
  - `deepbook ohlcv <pool>`
  - `deepbook stream ...`
  - `deepbook spot ...`
  - `deepbook swap ...`
  - `deepbook margin ...`
  - `deepbook manager ...`
  - `deepbook config ...`
  - `deepbook account ...`

- `deepbook config`:
  - `show`
  - `set-network <network>`
  - `set-provider <provider>`
  - `set-rpc-url <network> <url>`
  - `set-address <address>`
  - `set-trade-cap <id>`
  - `set-read-key [apiKey]`
  - `set-stream-key <pool> [apiKey]`
  - `set-provider-base-url <network> <url>`
  - `set-provider-stream-base-url <network> <url>`
  - `import-key [privateKey]`

- `deepbook account`:
  - `details`
  - `list`
  - `balance`
  - `import <alias> [privateKey]`
  - `use <alias>`

- `deepbook stream`:
  - `trades <pool>`

- `deepbook spot`:
  - `pools`
  - `buy <pool>`
  - `sell <pool>`
  - `limit <pool>`

- `deepbook swap`:
  - `base-for-quote <pool>`
  - `quote-for-base <pool>`

- `deepbook margin`:
  - `pools`
  - `managers`
  - `deposit <pool>`
  - `market <pool>`
  - `limit <pool>`
  - `position <pool>`
  - `close <pool>`

- `deepbook manager`:
  - `ls`
  - `create`
  - `deposit`
  - `withdraw`
  - `balance`

## Command cheat sheet (required args/options)

- `deepbook providers`
- `deepbook pools`
- `deepbook orderbook <pool>`
- `deepbook trades <pool>`
- `deepbook ohlcv <pool>`
- `deepbook stream trades <pool>`
- `deepbook spot pools`
- `deepbook spot buy <pool> --quantity <value> [--price <value>] [--manager <id>]`
- `deepbook spot sell <pool> --quantity <value> [--price <value>] [--manager <id>]`
- `deepbook spot limit <pool> --side <buy|sell> --price <value> --quantity <value> [--manager <id>]`
- `deepbook spot limit <pool> --cancel <id> [--manager <id>]`

- `deepbook config show`
- `deepbook config set-network <mainnet|testnet>`
- `deepbook config set-provider <surflux>`
- `deepbook config set-rpc-url <mainnet|testnet> <url>`
- `deepbook config set-address <address>`
- `deepbook config set-trade-cap <objectId>`
- `deepbook config set-read-key [apiKey]` (or `--stdin`)
- `deepbook config set-stream-key <pool> [apiKey]` (or `--stdin`)
- `deepbook config set-provider-base-url <mainnet|testnet> <url>`
- `deepbook config set-provider-stream-base-url <mainnet|testnet> <url>`
- `deepbook config import-key [privateKey]` (or `--stdin`, optional `--alias`)

- `deepbook account details`
- `deepbook account list`
- `deepbook account balance [--coin <SUI|USDC|DEEP|coinType>]`
- `deepbook account import <alias> [privateKey]` (or `--stdin`)
- `deepbook account use <alias>`


- `deepbook swap base-for-quote <pool> --amount <value>`
- `deepbook swap quote-for-base <pool> --amount <value>`

- `deepbook margin pools`
- `deepbook margin managers`
- `deepbook margin deposit <pool> --coin <BASE|QUOTE|DEEP|coinKey> --amount <value> [--margin-manager <id>]`
- `deepbook margin market <pool> --side <buy|sell> --quantity <value> [--margin-manager <id>]`
- `deepbook margin limit <pool> --side <buy|sell> --price <value> --quantity <value> [--margin-manager <id>]`
- `deepbook margin position <pool> [--margin-manager <id>]`
- `deepbook margin close <pool> [--margin-manager <id>]` + either:
  - `--full`
  - OR `--side <buy|sell> --quantity <value>`

- `deepbook manager ls`
- `deepbook manager create`
- `deepbook manager deposit --coin <key> --amount <value> [--manager <id>]`
- `deepbook manager withdraw --coin <key> --amount <value> [--manager <id>]`
- `deepbook manager balance --coin <key> [--manager <id>]`

## Key margin close flags

- `deepbook margin close <pool> --full --withdraw`
- `deepbook margin close <pool> --full --non-reduce-only`
- `deepbook margin close <pool> --side <buy|sell> --quantity <q> --reduce-only --no-repay`

## Swap vs spot market buy

- Swap (`deepbook swap quote-for-base`) is a direct pool swap with exact-input semantics.
- Spot market buy (`deepbook spot buy <pool> --quantity ...`) is an orderbook market order and uses a balance manager.
- CLI output now includes `execution.kind` and `execution.type/direction` so the mode is explicit.

## Safety defaults

- Prefer `--dry-run` first for all state-changing commands.
- Validate pool key and manager object ID before placing/canceling orders.
- SUI-involved deposit/collateral paths split from gas coin inside the transaction automatically.
- Never print or log private keys.
- Margin manager type safety:
  - Margin managers are generic typed objects: `MarginManager<Base, Quote>`.
  - The margin manager type must match the exact pool pair being traded.
  - Example: `MarginManager<DEEP,USDC>` works with `DEEP_USDC`, not `DEEP_SUI`.
- Margin manager resolution behavior:
  - If `--margin-manager` is omitted, CLI auto-selects a compatible manager for that pool, or creates one in-transaction if none exists.
  - If `--margin-manager` is provided, CLI treats it as explicit and strict: it must match signer + pool; no fallback or auto-create is performed.
- Internal margin fee buffer behavior:
  - Margin market/limit orders auto-deposit a fee buffer before placing the order.
  - With `--no-pay-with-deep`, buffer is deposited in trade asset collateral (base for sell, quote for buy).
  - Without `--no-pay-with-deep`, buffer is deposited as DEEP into the margin manager.
- Full-close quantity normalization:
  - `deepbook margin close <pool> --full` now auto-normalizes inferred quantity to pool lot-size/min-size.
  - If reduce-only full close cannot satisfy lot-size exactly, CLI auto-switches to non-reduce-only and rounds up, then repays debt in the same transaction.
  - If user explicitly passes `--reduce-only`, CLI keeps reduce-only semantics and errors when full close cannot be represented as a valid lot-size quantity.

## End-to-end spot trading flow (fund -> buy -> withdraw)

Use this when executing a real spot trade through a balance manager.

1. Discover balance managers:
   - `deepbook manager ls`
2. If none exist, create one:
   - `deepbook manager create`
3. Deposit quote coin to manager (for `DEEP_SUI` buy, fund `SUI`):
   - `deepbook manager deposit --coin SUI --amount 1 --manager <id>`
4. Optional balance check:
   - `deepbook manager balance --coin SUI --manager <id>`
5. Simulate buy first:
   - `deepbook spot buy DEEP_SUI --quantity 38 --manager <id> --no-pay-with-deep --dry-run`
6. Execute live buy:
   - `deepbook spot buy DEEP_SUI --quantity 38 --manager <id> --no-pay-with-deep`
7. Withdraw purchased asset to signer address (or explicit recipient):
   - `deepbook manager withdraw --coin DEEP --amount 38 --manager <id>`
   - optional recipient: `--recipient <address>`
8. Verify manager balance:
   - `deepbook manager balance --coin DEEP --manager <id>`

## Spot trade troubleshooting

- `MoveAbort ... balance_manager::withdraw_with_proof code=3` means manager available balance is too low.
- This includes fees/reserved amounts, not just raw deposited balance.
- For spot buys, ensure quote coin is funded in manager (for `DEEP_SUI`, quote is `SUI`).
- If fees are attempted in DEEP and manager lacks DEEP, either deposit DEEP or pass `--no-pay-with-deep`.
- When manager is omitted, CLI resolves dynamically:
  - one manager found -> uses it
  - none found -> error
  - multiple found -> require `--manager <id>`


## Typical workflow

1. Inspect pools/orderbook (`deepbook spot pools`, `deepbook margin pools`, `deepbook orderbook ...`).
2. Confirm manager ID (`deepbook manager ls`).
3. Simulate order (`deepbook spot buy ... --dry-run`).
4. Execute live order (same command without `--dry-run`).
5. Monitor with `deepbook orderbook --watch` and `deepbook stream trades ...`.
