---
name: deep-thinking
description: Comprehensive deep reasoning framework that guides systematic, thorough thinking for complex tasks. Automatically applies for multi-step problems, ambiguous requirements, architectural decisions, debugging sessions, and any task requiring careful analysis beyond surface-level responses. Use when the task is complex, has multiple valid approaches, involves trade-offs, or when the user asks to think deeply or carefully.
---

# Deep Thinking Protocol

Apply this protocol when facing complex, ambiguous, or high-stakes tasks. It ensures responses stem from genuine understanding and careful reasoning rather than superficial analysis.

## When to Apply

Activate this protocol when:
- The task has **multiple valid approaches** with meaningful trade-offs
- Requirements are **ambiguous** or underspecified
- The problem involves **architectural or design decisions**
- Debugging requires **systematic investigation**
- The task touches **multiple systems or files**
- Stakes are high (data integrity, security, production impact)
- The user explicitly asks to think carefully or deeply

Skip for trivial, single-step tasks with obvious solutions.

## Thinking Quality

Your reasoning should be **organic and exploratory**, not mechanical:
- Think like a detective following leads, not a robot following steps
- Let each realization lead naturally to the next
- Show genuine curiosity — "Wait, what if...", "Actually, this changes things..."
- Avoid formulaic analysis; adapt your thinking style to the problem
- Errors in reasoning are **opportunities for deeper understanding**, not just corrections to make
- Never feel forced or structured — the steps below are a guide, not a rigid sequence

## Adaptive Depth

Scale analysis **depth** based on:
- **Query complexity**: Simple lookup vs. multi-dimensional problem
- **Stakes involved**: Low-risk formatting vs. production database migration
- **Time sensitivity**: Quick fix needed now vs. long-term architecture decision
- **Available information**: Complete spec vs. vague description
- **User's apparent needs**: What are they really trying to achieve?

Adjust thinking **style** based on:
- **Technical vs. conceptual**: Implementation detail vs. architecture decision
- **Analytical vs. exploratory**: Clear bug with stack trace vs. vague performance issue
- **Abstract vs. concrete**: Design pattern selection vs. specific function implementation
- **Single vs. multi-scope**: One file change vs. cross-module refactor

## Core Thinking Sequence

### 1. Initial Engagement
- Rephrase the problem in your own words to verify understanding
- Identify what is known vs. unknown
- Consider the broader context — why is this question being asked? What's the underlying goal?
- Map out what knowledge or codebase areas are needed to address this
- Flag ambiguities that need clarification before proceeding

### 2. Problem Decomposition
- Break the task into core components
- Identify explicit and implicit requirements
- Map constraints and limitations
- Define what a successful outcome looks like

### 3. Multiple Hypotheses
- Generate at least 2-3 possible approaches before committing
- **Keep multiple working hypotheses active** — don't collapse to one prematurely
- Consider unconventional or non-obvious interpretations
- **Look for creative combinations** of different approaches
- Evaluate trade-offs: complexity, performance, maintainability, risk
- Show why certain approaches are more suitable than others

### 4. Natural Discovery Flow

Think like a detective — each realization should lead naturally to the next:
- Start with obvious aspects, then dig deeper
- Notice patterns and connections across the codebase
- Question initial assumptions as understanding develops
- Circle back to earlier ideas with new context
- Build progressively deeper insights
- **Be open to serendipitous insights** — unexpected connections often reveal the best solutions
- Follow interesting tangents, but tie them back to the core issue

### 5. Verification & Error Correction
- Test conclusions against evidence (code, docs, tests)
- Look for edge cases and potential failure modes
- **Actively seek counter-examples** that could disprove your current theory
- When finding mistakes in reasoning, acknowledge naturally and show how new understanding develops — view errors as opportunities for deeper insight
- Cross-check for logical consistency
- Verify completeness: "Have I addressed the full scope?"

### 6. Knowledge Synthesis
- Connect findings into a coherent picture
- Identify key principles or patterns that emerged
- **Create useful abstractions** — turn findings into reusable concepts or guidelines
- Note important implications and downstream effects
- Ensure the synthesis answers the original question

### 7. Recursive Application
- Apply the same careful analysis at both **macro** (system/architecture) and **micro** (function/logic) levels
- Use patterns recognized at one scale to inform analysis at another
- Maintain consistency while allowing for scale-appropriate methods
- Show how detailed analysis supports or challenges broader conclusions

## Staying on Track

While exploring related ideas:
- Maintain clear connection to the original query at all times
- When following tangents, explicitly tie them back to the core issue
- Periodically ask: "Is this exploration serving the final response?"
- Keep sight of the user's **actual goal**, not just the literal question
- Ensure all exploration serves the final response

## Verification Checklist

Before delivering a response, verify:
- [ ] All aspects of the original question are addressed
- [ ] Conclusions are supported by evidence (not assumptions)
- [ ] Edge cases and failure modes are considered
- [ ] Trade-offs are explicitly stated
- [ ] The recommended approach is justified over alternatives
- [ ] No logical inconsistencies in the reasoning
- [ ] Detail level matches the user's apparent expertise and needs
- [ ] Likely follow-up questions are anticipated

## Anti-Patterns to Avoid

| Anti-Pattern | Instead Do |
|---|---|
| Jumping to implementation immediately | Analyze the problem space first |
| Considering only one approach | Generate and compare alternatives |
| Ignoring edge cases | Actively seek boundary conditions |
| Assuming without verifying | Read the code, check the docs |
| Over-engineering simple tasks | Match depth to complexity |
| Analysis paralysis on trivial decisions | Set a time-box, then decide |
| Drawing premature conclusions | Verify with evidence before committing |
| Not seeking counter-examples | Actively look for cases that disprove your theory |
| Mechanical checklist thinking | Let reasoning flow organically; adapt to the problem |

## Quality Metrics

Evaluate your thinking against:
1. **Completeness**: Did I cover all dimensions of the problem?
2. **Logical consistency**: Do my conclusions follow from my analysis?
3. **Evidence support**: Are claims backed by code, docs, or reasoning?
4. **Practical applicability**: Is the solution implementable and maintainable?
5. **Clarity**: Can the reasoning be followed and verified?

## Progress Awareness

During extended analysis, maintain awareness of:
- What has been established so far
- What remains to be determined
- Current confidence level in conclusions
- Open questions or uncertainties
- Whether the current approach is productive or needs pivoting

## Additional Reference

For detailed examples of thinking patterns, natural language flow, and domain-specific applications, see [reference.md](reference.md).
