# Research Methodology

This document provides detailed strategies for conducting deep research, including advanced search techniques, source evaluation frameworks, and critical thinking applications.

## Advanced Search Strategies

### Progressive Depth Strategy

Conduct research in layers, progressively narrowing focus:

**Layer 1: Landscape Overview**
- Broad searches to understand the topic domain
- Identify major themes, key players, and foundational concepts
- Discover authoritative sources and seminal works
- Example query: "artificial intelligence healthcare overview"

**Layer 2: Focused Investigation**
- Target specific sub-topics identified in Layer 1
- Investigate relationships and connections between concepts
- Example query: "machine learning diagnostic imaging radiology"

**Layer 3: Detail Extraction**
- Deep dives into specific aspects or case studies
- Gather quantitative data, specific examples, expert opinions
- Example query: "AI diagnostic accuracy mammography clinical trials 2023"

**Layer 4: Verification and Validation**
- Cross-check critical claims with independent sources
- Verify statistics and quotes against primary sources
- Example query: "[specific claim or statistic] verification"

### Entity-Based Research Protocol

When researching multiple entities (companies, technologies, people, etc.):

1. **List all entities** to be researched
2. **Prioritize** based on importance or logical sequence
3. **Research each entity completely** before moving to the next:
   - Background and context
   - Key characteristics or features
   - Performance metrics or outcomes
   - Expert opinions or analyses
   - Recent developments
4. **Document findings** for each entity before proceeding
5. **Compare and contrast** only after all entities are researched

**Anti-pattern**: Do NOT interleave research (e.g., researching Entity A's background, then Entity B's background, then back to Entity A's performance). This fragments understanding and increases error risk.

### Attribute Decomposition

For a single complex entity, decompose into distinct attributes:

**Example: Researching a technology**
1. Technical specifications and capabilities
2. Development history and evolution
3. Current adoption and market penetration
4. Advantages and limitations
5. Competitive landscape
6. Future trajectory and potential
7. Regulatory or ethical considerations

Research each attribute through separate, focused searches.

### Multi-Lingual Search Execution

Information is often language-specific. To conduct effective multi-lingual research:

#### Language Selection
- Identify the most relevant languages for the topic
- Consider: geographic focus, origin of technology/concept, major research centers
- Minimum: two languages (typically English + one other)

#### Translation Accuracy
- Translate key terms carefully (use technical dictionaries, expert sources)
- Be aware of false cognates and context-dependent meanings
- Verify translations by checking bilingual sources

#### Cross-Language Comparison
- Note where information differs across language domains
- Identify region-specific perspectives or data
- Recognize where certain information exists only in one language sphere
- Consider cultural or regional biases in different language sources

#### Practical Execution
1. Formulate search query in primary language (e.g., English)
2. Translate key terms for secondary language (e.g., Japanese)
3. Conduct searches in both languages
4. Use WebFetch to access full content from both language spheres
5. Synthesize findings, noting similarities and differences

## Source Evaluation Framework

### Credibility Assessment

Evaluate each source using these criteria:

#### Author Expertise
- Does the author have relevant credentials, education, or experience?
- Is the author affiliated with a reputable institution?
- Has the author published other work in this field?
- Is the author recognized as an expert by peers?

#### Publication Quality
- Is this a peer-reviewed journal, established news organization, or reputable institution?
- What is the publication's reputation in the field?
- Does the publication have editorial standards and fact-checking processes?
- Is the publication indexed in academic databases?

#### Evidence and Methodology
- Does the source provide evidence for its claims?
- If research, is the methodology clearly described?
- Are sample sizes, data sources, and limitations acknowledged?
- Can the findings be verified or replicated?

#### Objectivity and Bias
- Does the author or publication have potential conflicts of interest?
- Is the tone neutral and analytical, or advocacy-oriented?
- Are alternative viewpoints acknowledged?
- Who funded the research or publication?

#### Currency
- When was the information published?
- For rapidly evolving topics, is the information current?
- Has the information been updated or superseded?
- Are there more recent sources on the same topic?

### Source Hierarchy

When multiple sources are available, prioritize in this order:

1. **Primary sources**: Original research, official data, firsthand accounts
2. **Peer-reviewed academic publications**: Journal articles, conference papers
3. **Reputable institutional sources**: Government agencies, established research organizations, universities
4. **Expert analysis**: Reports by recognized experts with clear credentials
5. **Quality journalism**: Established news organizations with fact-checking standards
6. **Secondary sources**: Textbooks, review articles, encyclopedias (for background)
7. **Tertiary sources**: Wikis, general websites (for preliminary exploration only)

### Red Flags

Be cautious of sources exhibiting:

- Lack of author attribution or credentials
- Absence of citations or references
- Extreme or inflammatory language
- Logical fallacies or unsupported assertions
- Conflicts of interest not disclosed
- Outdated information presented as current
- Cherry-picked data without context
- Inability to verify claims independently

## Critical Thinking Application

### Question Everything

Apply systematic skepticism:

- **Who says so?** Evaluate the source
- **How do they know?** Examine the evidence and methodology
- **What's the evidence?** Assess quality and sufficiency of data
- **Are there alternative explanations?** Consider other interpretations
- **What's missing?** Identify gaps or omitted information
- **Whose interests are served?** Recognize potential biases

### Identify Logical Fallacies

Watch for common reasoning errors:

- **Correlation vs. causation**: Correlation does not imply causation
- **Cherry picking**: Selecting only data that supports a conclusion
- **Appeal to authority**: Relying on authority without evidence
- **Bandwagon**: Something is true because many people believe it
- **Strawman**: Misrepresenting an opposing argument
- **False dichotomy**: Presenting only two options when more exist
- **Hasty generalization**: Drawing broad conclusions from limited data

### Synthesis and Integration

After gathering information from multiple sources:

1. **Identify consensus**: Where do credible sources agree?
2. **Note disagreements**: Where do sources diverge, and why?
3. **Evaluate evidence quality**: Which claims have stronger support?
4. **Recognize uncertainty**: What remains unknown or debated?
5. **Construct coherent narrative**: Integrate findings into a comprehensive understanding
6. **Acknowledge limitations**: Be transparent about gaps and uncertainties

## Handling Common Research Challenges

### Conflicting Information

When sources contradict each other:

1. Check the date: Is one source more recent?
2. Evaluate credibility: Which source is more authoritative?
3. Examine methodology: Are there differences in how data was collected or analyzed?
4. Look for context: Are the sources discussing exactly the same thing, or are there subtle differences?
5. Seek additional sources: Find a third (or fourth) perspective
6. Present both sides: If credible sources disagree, report the disagreement and explain possible reasons

### Information Scarcity

When information on a topic is limited:

1. Broaden the search: Use more general terms or related concepts
2. Try different search terms: Use synonyms, alternative phrasings
3. Search in multiple languages: Information might exist in other language spheres
4. Consult experts: Look for expert opinions or analyses that might address the topic indirectly
5. Use related topics: If direct information is unavailable, research related areas and extrapolate carefully
6. Acknowledge gaps: Be transparent about what information could not be found

### Information Overload

When faced with excessive information:

1. Refine search terms: Be more specific to narrow results
2. Use advanced search operators: Site-specific searches, date ranges, file types
3. Prioritize sources: Focus on the most authoritative and relevant
4. Create an organizational system: Track sources and key findings systematically
5. Set boundaries: Define scope clearly to avoid mission creep
6. Take iterative approach: Process information in manageable chunks

### Outdated Information

When current information is needed but sources are old:

1. Add date constraints to searches: Specify recent time periods
2. Search for "latest", "recent", "2023", "2024", etc.
3. Check for updates: Has the original source published updates?
4. Find news coverage: Recent news might report on new developments
5. Note the date: If using older sources, clearly indicate when the information was published
6. Explain context: Why older information is being used (e.g., historical context, lack of recent data)

## Documentation and Organization

### Tracking Sources

As you research, maintain organized records:

- **URL**: Full, complete URL for every source
- **Title**: Document or article title
- **Author/Organization**: Who published it
- **Date**: When it was published
- **Key findings**: Summary of relevant information
- **Credibility notes**: Assessment of source quality
- **Quote-worthy passages**: Specific text for potential citation

### Search Query Log

Keep track of searches performed:

- What query was used
- What language
- Key findings from that search
- URLs visited
- Gaps identified
- Follow-up questions generated

This log helps avoid redundant searches and ensures comprehensive coverage.

### Progressive Refinement

Use insights from each search round to refine subsequent searches:

- What new questions emerged?
- What terms or concepts need definition?
- What sources were most valuable?
- What perspectives are missing?
- What claims need verification?

Treat research as an iterative, self-correcting process, not a linear checklist.
