# Citation Guidelines

This document provides detailed instructions for citing sources and managing references in Deep Research reports.

## Core Citation Principles

### Every Claim Needs a Source

The following types of information MUST be cited:

- **Facts and statistics**: Any numerical data, percentages, statistics
- **Quotes**: Direct quotations from any source
- **Specific claims**: Assertions about events, trends, or phenomena
- **Research findings**: Results from studies, surveys, or investigations
- **Expert opinions**: Statements or analyses by domain experts
- **Historical information**: Dates, events, sequences of developments
- **Technical specifications**: Performance metrics, capabilities, features

### Exceptions (What Not to Cite)

The following generally do not require citations:

- **Common knowledge**: Widely known facts (e.g., "water boils at 100°C at sea level")
- **Your own analysis**: Your synthesis and interpretation of cited information (though the underlying facts must still be cited)
- **Logical deductions**: Conclusions you draw from cited evidence (clearly marked as interpretation)

**When in doubt, cite.** Over-citation is better than under-citation.

## Inline Citation Formats

Inline citations attribute information within the body text. Use these formats for readability and clarity.

### Narrative Citations

Integrate the source into the sentence structure:

**Format**: According to [Author/Organization] ([Year]), [claim or finding].

**Examples**:

> According to the World Health Organization (2023), approximately 1.3 million people die each year as a result of road traffic crashes.

> Research conducted by the Pew Research Center (2022) found that 85% of Americans own a smartphone, up from just 35% in 2011.

> As documented by the International Energy Agency (2023), solar power capacity increased by 270 GW globally in 2022, representing a 37% year-over-year growth.

### Parenthetical Citations

Place the citation in parentheses after the information:

**Format**: [Claim or finding] ([Author/Organization], [Year]).

**Examples**:

> Global carbon dioxide emissions reached a record high of 36.8 billion tonnes in 2022 (International Energy Agency, 2023).

> The average cost of lithium-ion batteries has fallen by 89% over the past decade (BloombergNEF, 2023).

### Direct Quotations

For direct quotes, use quotation marks and cite the source:

**Format**: "[Direct quote]" ([Author/Organization], [Year]).

**Examples**:

> "Artificial intelligence is the new electricity," stated Andrew Ng (2017), emphasizing its transformative potential across industries.

> The report concluded that "current climate commitments fall significantly short of what is needed to limit warming to 1.5°C" (United Nations Environment Programme, 2023).

### Multiple Sources for One Claim

When multiple sources support the same claim:

**Format**: [Claim] ([Source 1], [Year]; [Source 2], [Year]; [Source 3], [Year]).

**Example**:

> Multiple studies have demonstrated the effectiveness of vaccine mandates in increasing vaccination rates (Harvard School of Public Health, 2022; Johns Hopkins University, 2022; Nature Medicine, 2023).

### Sequential Information

When presenting information from the same source across multiple sentences:

**First mention**: Use full citation
**Subsequent mentions in same paragraph**: May use "the study", "the report", "the researchers", etc.
**New paragraph**: Cite again if still using the same source

**Example**:

> According to a comprehensive study by McKinsey & Company (2023), automation could displace up to 30% of current work activities by 2030. The study examined over 2,000 work activities across 800 occupations in 46 countries. The researchers found that the pace of automation would be influenced by several factors, including technological feasibility, cost, labor supply and demand, and social acceptance.

## Reference Section Format

The References section appears at the end of the report and lists all sources in full.

### Basic Format for Web Sources

```
[Author/Organization]. ([Year]). [Title]. Retrieved from [Full URL]
```

### Detailed Examples

#### Organization as Author

```
International Energy Agency. (2023). World Energy Outlook 2023. Retrieved from https://www.iea.org/reports/world-energy-outlook-2023
```

#### Individual Author(s)

```
Smith, J. (2022). The Future of Renewable Energy. Retrieved from https://www.example.com/future-renewable-energy

Johnson, K., & Williams, M. (2023). Climate Change and Agricultural Productivity. Retrieved from https://www.sciencedirect.com/article/climate-agriculture
```

#### News Article

```
Thompson, R. (2023, November 3). New Study Reveals Impact of AI on Employment. The New York Times. Retrieved from https://www.nytimes.com/2023/11/03/technology/ai-employment-study.html
```

#### Report or White Paper

```
World Economic Forum. (2023). The Global Risks Report 2023. Retrieved from https://www.weforum.org/reports/global-risks-report-2023
```

#### Academic Journal Article (Online)

```
Lee, S., Park, J., & Kim, H. (2023). Machine Learning Applications in Drug Discovery. Nature Medicine, 29(4), 456-468. Retrieved from https://www.nature.com/articles/nm.2023.456
```

#### Government Source

```
U.S. Environmental Protection Agency. (2023). Climate Change Indicators in the United States, 2023. Retrieved from https://www.epa.gov/climate-indicators
```

### Organization and Ordering

**Alphabetical by author/organization**: List all references in alphabetical order by the first author's last name or organization name.

**Example**:

```
## References

BloombergNEF. (2023). Battery Pack Prices Fall to an Average of $139/kWh. Retrieved from https://about.bnef.com/blog/battery-pack-prices-fall-to-139-kwh

International Energy Agency. (2023). CO2 Emissions in 2022. Retrieved from https://www.iea.org/reports/co2-emissions-in-2022

McKinsey & Company. (2023). The Economic Potential of Generative AI. Retrieved from https://www.mckinsey.com/capabilities/mckinsey-digital/our-insights/economic-potential-generative-ai

Smith, J., & Johnson, K. (2022). The Economics of Solar Energy: A Meta-Analysis. Journal of Sustainable Energy, 15(3), 234-256. Retrieved from https://example.com/article

World Health Organization. (2023). Road Traffic Injuries. Retrieved from https://www.who.int/news-room/fact-sheets/detail/road-traffic-injuries
```

## Citation Management Best Practices

### During Research

As you gather information:

1. **Capture full citation information immediately**: Don't rely on memory or incomplete notes
2. **Record the exact URL**: Copy the complete URL, not just the domain
3. **Note the access date if content may change**: For pages without clear publication dates
4. **Take careful notes**: Distinguish between direct quotes, paraphrases, and your own thoughts

### URL Quality Control

Ensure all URLs are:

- **Complete**: Include the full path, not just the domain
- **Direct**: Link to the specific page or article, not a general homepage
- **Accessible**: Test links to ensure they work (not behind paywalls if possible, or note if paywalled)
- **Stable**: Use permanent links or DOIs when available

**Good URL**:
```
https://www.nature.com/articles/s41586-023-06221-2
```

**Bad URL**:
```
https://www.nature.com
```

### Avoiding Common Citation Errors

#### Error: Citing the Aggregator Instead of the Original

**Wrong**:
> According to Google News (2023), unemployment rates fell to 3.5%.

**Right**:
> According to the U.S. Bureau of Labor Statistics (2023), unemployment rates fell to 3.5%.

Even if you found the information via an aggregator, cite the original source and access the original URL.

#### Error: Missing URLs

**Wrong**:
```
World Bank. (2023). Global Economic Prospects.
```

**Right**:
```
World Bank. (2023). Global Economic Prospects, June 2023. Retrieved from https://www.worldbank.org/en/publication/global-economic-prospects
```

Always include complete URLs for web sources.

#### Error: Vague Source Attribution

**Wrong**:
> Studies show that meditation reduces stress.

**Right**:
> Research by the American Psychological Association (2022) demonstrates that regular meditation practice significantly reduces cortisol levels, a key stress biomarker.

Be specific about which study, which organization, which year.

#### Error: Inconsistent Formatting

Maintain consistent formatting throughout the References section:
- Same date format (Year) vs. (Month Day, Year)
- Same structure for titles (sentence case vs. title case)
- Same URL presentation

Choose one style and apply it uniformly.

### Plagiarism Avoidance

Even with citations, avoid plagiarism:

#### Proper Paraphrasing

**Original text**:
> "The rapid advancement of artificial intelligence has created both opportunities and challenges for the global workforce, with some jobs becoming obsolete while new roles emerge."

**Plagiarism (too close to original, even with citation)**:
> The quick advancement of AI has created opportunities and challenges for the workforce, with jobs becoming obsolete and new roles emerging (Smith, 2023).

**Proper paraphrase with citation**:
> According to Smith (2023), the accelerating development of AI technologies presents a dual impact on employment, simultaneously eliminating certain positions while generating demand for previously non-existent roles.

#### Direct Quotes for Unique Phrasing

When the original phrasing is particularly important or eloquent, use a direct quote:

> As Smith (2023) eloquently stated, "The rapid advancement of artificial intelligence has created both opportunities and challenges for the global workforce, with some jobs becoming obsolete while new roles emerge."

## Multi-Language Source Citations

When citing sources in multiple languages:

### Non-English Sources

**Option 1: Original title with translation**
```
Müller, H. (2023). Die Zukunft der erneuerbaren Energien [The Future of Renewable Energy]. Retrieved from https://www.example.de/article
```

**Option 2: Translated title with note**
```
Müller, H. (2023). The Future of Renewable Energy [Translated from German]. Retrieved from https://www.example.de/article
```

### Maintaining Language Diversity in References

When research includes sources from multiple languages, include sources from each language in the References section. This demonstrates the multi-lingual research approach and acknowledges diverse perspectives.

**Example**:
```
## References

Nakamura, T. (2023). 人工知能の倫理的課題 [Ethical Challenges of Artificial Intelligence]. Retrieved from https://www.example.jp/ai-ethics

Smith, J. (2023). AI Ethics in the Modern Era. Retrieved from https://www.example.com/ai-ethics

Dupont, M. (2023). L'éthique de l'intelligence artificielle [The Ethics of Artificial Intelligence]. Retrieved from https://www.example.fr/ethique-ia
```

## Quality Check for Citations

Before finalizing the report, verify:

- [ ] Every factual claim has a source
- [ ] Every source has a full URL
- [ ] All URLs are accessible and direct
- [ ] References section includes all cited sources
- [ ] No cited source is missing from References section
- [ ] Formatting is consistent throughout
- [ ] Author/organization names are spelled correctly
- [ ] Dates are accurate
- [ ] Quotations are word-for-word accurate and properly marked

A well-cited report demonstrates rigor, enables readers to verify claims, and gives proper credit to original researchers and authors. Citations are not bureaucratic overhead—they are fundamental to credible research.
